<?php

namespace App\Exports;

use App\Models\UserInfoModel;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class MembersExport implements FromCollection, WithHeadings, WithMapping
{
    public function collection()
    {
        return UserInfoModel::with(['province', 'district', 'commune', 'village', 'education', 'educationYear', 'monkType', 'kudi'])
            ->orderBy('kudi_id')
            ->orderBy('name_kh')
            ->get();
    }

    public function headings(): array
    {
        return [
            'ល.រ',
            'អត្តលេខ',
            'គោត្តនាមនិងនាម',
            'អក្សរឡាតាំង',
            'កុដិ',
            'ថ្ងៃខែឆ្នាំកំណើត',
            'ភូមិ',
            'ឃុំ',
            'ស្រុក',
            'ខេត្ត',
            'កម្រិតវប្បធម៌មុន',
            'ឈ្មោះឪពុក',
            'មុខរបរឪពុក',
            'ឈ្មោះម្តាយ',
            'មុខរបរម្តាយ',
            'កម្រិតបាលីធម្មវិន័យ',
            'ថ្នាក់',
            'ឆ្នាំ',
        ];
    }

    public function map($member): array
    {
        return [
            $member->id,
            $member->id_number ?? '',
            $member->name_kh ?? '',
            $member->name_en ?? '',
            $member->kudi->kudi_number ?? '',
            $member->dob ?? '',
            $member->village->name ?? '',
            $member->commune->name ?? '',
            $member->district->name ?? '',
            $member->province->name ?? '',
            $member->education->name ?? '',
            $member->father_name ?? '',
            $member->father_job ?? '',
            $member->mother_name ?? '',
            $member->mother_job ?? '',
            $member->educationYear->name ?? '',
            $member->monkType->name ?? '',
            '',
        ];
    }
}
