<?php

namespace App\Http\Controllers;

use App\Models\Commune;
use App\Models\District;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class CommuneController extends Controller
{
    public function index()
    {
        $com = Commune::with('district')->paginate(10);
        return view('admin.commune.index', compact('com'));
    }
    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->save($request);
            return redirect()->route('commune.index');
        }
        $dis = District::all();
        $com = new District();
        return view('admin.commune.form', compact('com', 'dis'));
    }
    public function edit(Request $request, $id)
    {
        $com = Commune::find($id);
        if ($request->isMethod('post')) {
            $this->save($request, $id);
            return redirect()->route('commune.index');
        }
        $dis = District::all();
        return view('admin.commune.form', compact('com', 'dis'));
    }
    public function delete($id)
    {
        $com = Commune::find($id);
        $com->delete();
        return redirect()->route('district.index');
    }
    private function save(Request $request, $id = null)
    {
        $validated = $request->validate([
            'name' => 'required',
            'district_id' => 'required|exists:district,id'
        ]);

        $data = $request->only(['name', 'district_id']);
        if ($id) {
            $com = Commune::find($id);
        }
        if ($id) {
            $com->update($data);
        } else {
            $com = Commune::create($data);
        }
    }
}
