<?php

namespace App\Http\Controllers;
use App\Models\Education;
use Illuminate\Http\Request;
use App\Models\EducationYear;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class EducationYearController extends Controller
{
    public function index()
    {
        $eduyear = EducationYear::all();

        return view('admin.eduyear.index', compact('eduyear'));
    }
    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->save($request);
            return redirect()->route('educationyear.index');
        }
         $edu=Education::all();
         $eduyear = new EducationYear();
        return view('admin.eduyear.form', compact('eduyear','edu'));
    }
    public function edit(Request $request, $id)
    {
        $eduyear = EducationYear::find($id);
        if($request->isMethod('post')) {
            $this->save($request, $id);
            return redirect()->route('education.index');
        }
        $edu=Education::all();

        return view('admin.eduyear.form', compact('eduyear', 'edu'));
    }
    public function delete($id){
        $eduyear =EducationYear::find($id);
        $eduyear->delete();
        return redirect()->route('educationyear.index');
    }
    private function save(Request $request, $id = null)
    {
        $validated = $request->validate([
            'name' => 'required',
            'education_id' => 'required|exists:education,id'
        ]);

        $data = $request->only(['name', 'education_id']);
        if($id) {
            $eduyear = EducationYear::find($id);
        }
        if ($id) {
            $eduyear->update($data);
        } else {
            $eduyear = EducationYear::create($data);
        }

    }

    public function byEducation(Education $education)
    {
        return response()->json([
            'data' => $education->years()->orderBy('name')->get(['id', 'name']),
        ]);
    }






}
