<?php

namespace App\Http\Controllers;

use App\Models\Commune;
use App\Models\Village;
use App\Models\District;
use App\Models\Province;
use App\Models\FatherModel;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class FatherController extends Controller
{
    public function index()
    {
        $father = FatherModel::all();
        return view('admin.father.index', compact('father'));
    }
    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->save($request);
            return redirect()->route('father.index');
        }

        // You MUST fetch the data here too, otherwise the 'create' page crashes
        $pro = Province::all();

        $provinceId = old('province_id', $request->input('province_id'));
        $districtId = old('district_id', $request->input('district_id'));
        $communeId  = old('commune_id', $request->input('commune_id'));

        $dis = $provinceId
            ? District::where('province_id', $provinceId)->get()
            : collect();

        $com = $districtId
            ? Commune::where('district_id', $districtId)->get()
            : collect();

        $vil = $communeId
            ? Village::where('commune_id', $communeId)->get()
            : collect();

        // Create an empty object so the form doesn't crash when looking for $father->name
        $father = new FatherModel();

        return view('admin.father.form', compact('father', 'pro', 'dis', 'com', 'vil'));
    }
    public function edit(Request $request, $id)
    {

        $father = FatherModel::find($id);
        if ($request->isMethod('post')) {
            $this->save($request, $id);
            return redirect()->route('father.index');
        }

        $father = FatherModel::findOrFail($id);
        $pro = Province::all();

        // 1. Determine which IDs to use (Request OR Database)
        $province_id = old('province_id', $request->input('province_id', $father->province_id));
        $district_id = old('district_id', $request->input('district_id', $father->district_id));
        $commune_id  = old('commune_id', $request->input('commune_id', $father->commune_id));

        // 2. Fetch lists based on those IDs so the dropdowns aren't empty
        $dis = $province_id ? District::where('province_id', $province_id)->get() : collect();
        $com = $district_id ? Commune::where('district_id', $district_id)->get() : collect();
        $vil = $commune_id  ? Village::where('commune_id', $commune_id)->get() : collect();

        return view('admin.father.form', compact('father', 'pro', 'dis', 'com', 'vil'));
    }
    private function save(Request $request, $id = null)
    {
        $validated = $request->validate([
            'name' => 'required',
            'job' => 'required',
            // Change from 'provinces' to 'province'
            'province_id' => 'required|exists:province,id',
            'district_id' => 'required|exists:district,id',
            'commune_id'  => 'required|exists:commune,id',
            'village_id'  => 'required|exists:village,id',
        ]);

        // Use the validated data to save
        if ($id) {
            $father = FatherModel::findOrFail($id);
            $father->update($validated);
        } else {
            FatherModel::create($validated);
        }
    }
    public function delete($id)
    {
        $father = FatherModel::find($id);

        $father->delete();
        return redirect()->route('father.index');
    }
}
