<?php

namespace App\Http\Controllers;

use App\Models\Commune;
use App\Models\District;
use App\Models\Province;
use Illuminate\Http\JsonResponse;

class LocationController extends Controller
{
    public function districts(Province $province): JsonResponse
    {
        $districts = $province->districts()
            ->select('id', 'name')
            ->orderBy('name')
            ->get();

        return response()->json(['data' => $districts]);
    }

    public function communes(District $district): JsonResponse
    {
        $communes = $district->communes()
            ->select('id', 'name')
            ->orderBy('name')
            ->get();

        return response()->json(['data' => $communes]);
    }

    public function villages(Commune $commune): JsonResponse
    {
        $villages = $commune->villages()
            ->select('id', 'name')
            ->orderBy('name')
            ->get();

        return response()->json(['data' => $villages]);
    }
}
