<?php

namespace App\Http\Controllers;

use App\Models\MonkType;
use Illuminate\Http\Request;

class MonktypeConroller extends Controller
{
    public function index(Request $request)
    {
        $monktypeQuery = MonkType::with('kudi');
        
        // Filter by kudi_id if provided
        $selectedKudiId = $request->query('kudi_id');
        if ($selectedKudiId) {
            $monktypeQuery->where('kudi_id', $selectedKudiId);
        }
        
        $monktype = $monktypeQuery->get();
        $kudis = \App\Models\KudiModel::orderByRaw('CAST(kudi_number AS UNSIGNED)')->get();
        
        // If it's an AJAX request, return JSON response
        if ($request->ajax()) {
            $view = view('admin.monktype.partials.monktype_table', compact('monktype'))->render();
            return response()->json([
                'success' => true,
                'html' => $view,
                'monktype_count' => $monktype->count()
            ]);
        }
        
        return view('admin.monktype.index', compact('monktype', 'kudis'));
    }

    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->save($request);
            return redirect()->route('monktype.index');
        }
        $monktype = new MonkType();
        return view('admin.monktype.form',compact('monktype'));
    }

    public function edit(Request $request, $id)
    {

        $monktype = MonkType::find($id);
        if ($request->isMethod('post')) {
            $this->save($request, $id);
            return redirect()->route('monktype.index');
        }
        return view('admin.monktype.form', compact('monktype'));
    }
     public function delete($id)
    {
        $monktype = MonkType::find($id);


        $monktype->delete();
        return redirect()->route('monktype.index');
    }
    private function save(Request $request, $id = null)
    {
        $validated = $request->validate([
            'name' => 'required',

        ]);

        $data = $request->only(['name']);


        if ($id) {
            $monktype =  MonkType::find($id);
        }

        if ($id) {
            $monktype->update($data);
        } else {
            $monktype =  MonkType::create($data);
        }
    }
}
