<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FatherModel extends Model
{
   protected $table = 'father_info';

    protected $fillable = [
        'name', 'job', 'province_id', 'district_id', 'commune_id', 'village_id'
    ];

    public function province()
    {
        return $this->belongsTo(Province::class, 'province_id');
    }
    public function district()
    {
        return $this->belongsTo(District::class, 'district_id');
    }
    public function commune()
    {
        return $this->belongsTo(Commune::class, 'commune_id');
    }
    public function village()
    {
        return $this->belongsTo(Village::class, 'village_id');
    }
}
