<?php

namespace App\Services;

use App\Models\UserInfoModel;
use Illuminate\Support\Collection;
use SimpleXMLElement;

class TemplateExportService
{
    public function exportFromTemplate(Collection $members, string $templatePath, string $filename)
    {
        // For now, create a CSV that matches your template structure
        // Later we can enhance this to actually read and modify the Excel template
        
        $tempFile = tempnam(sys_get_temp_dir(), 'template_export');
        $file = fopen($tempFile, 'w');
        
        // Add BOM for UTF-8 support
        fwrite($file, "\xEF\xBB\xBF");
        
        // Headers matching your template structure
        $headers = [
            'ល.រ',
            'អត្តលេខ',
            'គោត្តនាមនិងនាម',
            'អក្សរឡាតាំង',
            'កុដិ',
            'ថ្ងៃខែឆ្នាំកំណើត',
            'ភូមិ',
            'ឃុំ',
            'ស្រុក',
            'ខេត្ត',
            'កម្រិតវប្បធម៌មុន',
            'ឈ្មោះឪពុក',
            'មុខរបរឪពុក',
            'ឈ្មោះម្តាយ',
            'មុខរបរម្តាយ',
            'កម្រិតបាលីធម្មវិន័យ',
            'ថ្នាក់',
            'ឆ្នាំ',
        ];
        
        fputcsv($file, $headers, "\t");
        
        // Write data
        foreach ($members as $member) {
            $data = [
                $member->id,
                $member->id_number ?? '',
                $member->name_kh ?? '',
                $member->name_en ?? '',
                $member->kudi_number ?? $member->kudi->kudi_number ?? '',
                $member->dob ?? '',
                $member->village->name ?? '',
                $member->commune->name ?? '',
                $member->district->name ?? '',
                $member->province->name ?? '',
                $member->education->name ?? '',
                $member->father_name ?? '',
                $member->father_job ?? '',
                $member->mother_name ?? '',
                $member->mother_job ?? '',
                $member->education_year_name ?? $member->educationYear->name ?? '',
                $member->monkType->name ?? '',
                '',
            ];
            
            fputcsv($file, $data, "\t");
        }
        
        fclose($file);
        
        // Read the file and return as response
        $content = file_get_contents($tempFile);
        unlink($tempFile);
        
        return response($content)
            ->header('Content-Type', 'application/vnd.ms-excel; charset=UTF-8')
            ->header('Content-Disposition', 'attachment; filename="' . $filename . '"')
            ->header('Content-Length', strlen($content));
    }
    
    public function copyTemplateAndFillData(Collection $members, string $templatePath, string $filename)
    {
        // Create a proper CSV file that Excel can open
        $tempFile = tempnam(sys_get_temp_dir(), 'template_export');
        $file = fopen($tempFile, 'w');
        
        // Add BOM for UTF-8 support
        fwrite($file, "\xEF\xBB\xBF");
        
        // Headers matching your template structure
        $headers = [
            'ល.រ',
            'អត្តលេខ',
            'គោត្តនាមនិងនាម',
            'អក្សរឡាតាំង',
            'ភិក្ខុ/ សមណេរ',
            'ថ្ងៃខែឆ្នាំកំណើត',
            'ភូមិកំណើត',
            'ឃុំកំណើត',
            'ស្រុកកំណើត',
            'ខេត្តកំណើត',
            'ឈ្មោះឪពុក',
            'មុខរបរឪពុក',
            'ឈ្មោះម្តាយ',
            'មុខរបរម្តាយ',
            'ភូមិ',
            'ឃុំ',
            'ស្រុក',
            'ខេត្ត',
            'កម្រិត',
            'ឆ្នាំ',
        ];
        
        fputcsv($file, $headers, ",");
        
        // Write data
        foreach ($members as $member) {
            $data = [
                '', // Remove $member->id, leave empty for ល.រ column
                $member->id_number ?? '',
                $member->name_kh ?? '',
                $member->name_en ?? '',
                $member->monkType->name ?? '',
                $member->dob ?? '',
                $member->village->name ?? '',
                $member->commune->name ?? '',
                $member->district->name ?? '',
                $member->province->name ?? '',
                $member->father_name ?? '',
                $member->father_job ?? '',
                $member->mother_name ?? '',
                $member->mother_job ?? '',
                $member->currentVillage->name ?? '',
                $member->currentCommune->name ?? '',
                $member->currentDistrict->name ?? '',
                $member->currentProvince->name ?? '',
                $member->education->name ?? '',
                $member->education_year_name ?? '',
            ];
            
            fputcsv($file, $data, ",");
        }
        
        fclose($file);
        
        // Read the file and return as response
        $content = file_get_contents($tempFile);
        unlink($tempFile);
        
        // Change filename to .csv for proper Excel opening
        $csvFilename = str_replace('.xlsx', '.csv', $filename);
        
        return response($content)
            ->header('Content-Type', 'text/csv; charset=UTF-8')
            ->header('Content-Disposition', 'attachment; filename="' . $csvFilename . '"')
            ->header('Content-Length', strlen($content));
    }
}
