<?php

// Include Laravel's autoloader
require __DIR__.'/vendor/autoload.php';

// Bootstrap the application
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

echo "=== Database Connection Test ===\n";

try {
    // Test database connection
    DB::connection()->getPdo();
    echo "✅ Successfully connected to the database.\n";
    
    // List all tables
    $tables = DB::select('SHOW TABLES');
    echo "\n=== Database Tables ===\n";
    
    $dbName = DB::connection()->getDatabaseName();
    $key = 'Tables_in_' . strtolower($dbName);
    
    foreach ($tables as $table) {
        $tableName = $table->$key;
        echo "\n📊 Table: $tableName\n";
        
        // Check if table is empty
        $count = DB::table($tableName)->count();
        echo "   Records: $count\n";
        
        // Show first few rows if table is not empty
        if ($count > 0) {
            $columns = DB::getSchemaBuilder()->getColumnListing($tableName);
            echo "   Columns: " . implode(', ', $columns) . "\n";
            
            if ($count > 5) {
                $sample = DB::table($tableName)->take(3)->get();
                echo "   Sample data (first 3 rows):\n";
                foreach ($sample as $row) {
                    echo "   - " . json_encode($row, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
                }
            }
        }
    }
    
} catch (\Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n=== Check Complete ===\n";
