<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

// Get Kampong Thom province (ID: 4)
$province = DB::table('province')->find(4);

echo "=== Current Districts in {$province->name} ===\n";

$districts = DB::table('district')
    ->where('province_id', 4)
    ->orderBy('name')
    ->get();

foreach ($districts as $district) {
    $communeCount = DB::table('commune')
        ->where('district_id', $district->id)
        ->count();
    
    echo "- {$district->name} (ID: {$district->id}, Communes: {$communeCount})\n";
}

echo "\n=== Expected Districts in Kampong Thom (2025) ===\n";
$expectedDistricts = [
    'បាទី', 'បវេល', 'កំពង់ស្វាយ', 'ស្នោអណ្ដូង', 'ស្ទឹងសែន',
    'ប្រាសាទបល្ល័ង្ក', 'ប្រាសាទសំបូរ', 'សានុក', 'តាំងគោក'
];

foreach ($expectedDistricts as $district) {
    $exists = $districts->contains('name', $district) ? '✓' : '✗';
    echo "[{$exists}] {$district}\n";
}

echo "\n=== Note ===\n";
echo "If you see '✗' before a district name, it means it's missing from the database.\n";
echo "Let me know if you want to add the missing districts.\n";
