<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_info', function (Blueprint $table) {
            // Check if columns don't exist before adding them
            if (!Schema::hasColumn('user_info', 'temple_name')) {
                $table->string('temple_name')->nullable()->after('village_id'); // វត្តនាគវ័ន
            }
            if (!Schema::hasColumn('user_info', 'current_province_id')) {
                $table->unsignedBigInteger('current_province_id')->nullable()->after('temple_name');
            }
            if (!Schema::hasColumn('user_info', 'current_district_id')) {
                $table->unsignedBigInteger('current_district_id')->nullable()->after('current_province_id');
            }
            if (!Schema::hasColumn('user_info', 'current_commune_id')) {
                $table->unsignedBigInteger('current_commune_id')->nullable()->after('current_district_id');
            }
            if (!Schema::hasColumn('user_info', 'current_village_id')) {
                $table->unsignedBigInteger('current_village_id')->nullable()->after('current_commune_id');
            }
        });
        
        // Add foreign key constraints separately
        Schema::table('user_info', function (Blueprint $table) {
            if (Schema::hasColumn('user_info', 'current_province_id')) {
                $table->foreign('current_province_id')->references('id')->on('province')->onDelete('set null');
            }
            if (Schema::hasColumn('user_info', 'current_district_id')) {
                $table->foreign('current_district_id')->references('id')->on('district')->onDelete('set null');
            }
            if (Schema::hasColumn('user_info', 'current_commune_id')) {
                $table->foreign('current_commune_id')->references('id')->on('commune')->onDelete('set null');
            }
            if (Schema::hasColumn('user_info', 'current_village_id')) {
                $table->foreign('current_village_id')->references('id')->on('village')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_info', function (Blueprint $table) {
            $table->dropForeign(['current_province_id']);
            $table->dropForeign(['current_district_id']);
            $table->dropForeign(['current_commune_id']);
            $table->dropForeign(['current_village_id']);
            $table->dropColumn([
                'temple_name',
                'current_province_id',
                'current_district_id',
                'current_commune_id',
                'current_village_id'
            ]);
        });
    }
};
