<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class CambodiaGeography2024Seeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $this->command->info('Starting Cambodia Geography 2024 Seeder...');
        
        // Truncate existing data
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('village')->truncate();
        DB::table('commune')->truncate();
        DB::table('district')->truncate();
        DB::table('province')->truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        // Load the latest data from NCDD
        $this->seedProvinces();
        
        $this->command->info('Cambodia Geography 2024 data has been seeded successfully!');
    }

    protected function seedProvinces()
    {
        // Latest data as of 2024
        $provinces = [
            ['id' => 1,  'name' => 'បន្ទាយមានជ័យ'],
            ['id' => 2,  'name' => 'បាត់ដំបង'],
            ['id' => 3,  'name' => 'កំពង់ចាម'],
            ['id' => 4,  'name' => 'កំពង់ឆ្នាំង'],
            ['id' => 5,  'name' => 'កំពង់ស្ពឺ'],
            ['id' => 6,  'name' => 'កំពត'],
            ['id' => 7,  'name' => 'កណ្ដាល'],
            ['id' => 8,  'name' => 'កោះកុង'],
            ['id' => 9,  'name' => 'ក្រចេះ'],
            ['id' => 10, 'name' => 'មណ្ឌលគីរី'],
            ['id' => 11, 'name' => 'ភ្នំពេញ'],
            ['id' => 12, 'name' => 'ព្រះសីហនុ'],
            ['id' => 13, 'name' => 'ព្រះវិហារ'],
            ['id' => 14, 'name' => 'ពោធិ៍សាត់'],
            ['id' => 15, 'name' => 'ព្រៃវែង'],
            ['id' => 16, 'name' => 'ពោធិ៍សាត់'],
            ['id' => 17, 'name' => 'រតនគិរី'],
            ['id' => 18, 'name' => 'សៀមរាប'],
            ['id' => 19, 'name' => 'ព្រះសីហនុ'],
            ['id' => 20, 'name' => 'ស្ទឹងត្រែង'],
            ['id' => 21, 'name' => 'ស្វាយរៀង'],
            ['id' => 22, 'name' => 'តាកែវ'],
            ['id' => 23, 'name' => 'ឧត្តរមានជ័យ'],
            ['id' => 24, 'name' => 'កែប'],
            ['id' => 25, 'name' => 'ប៉ៃលិន'],
            ['id' => 26, 'name' => 'ត្បូងឃ្មុំ'],
        ];

        // Insert provinces
        foreach ($provinces as $province) {
            DB::table('province')->updateOrInsert(
                ['id' => $province['id']],
                ['name' => $province['name']]
            );
        }

        // Now seed districts for each province
        $this->seedDistricts();
    }

    protected function seedDistricts()
    {
        // This is a simplified example - in a real scenario, you would have all districts
        $districts = [
            // Banteay Meanchey (ID: 1)
            ['id' => 101, 'province_id' => 1, 'name' => 'មង្គលបូរី'],
            ['id' => 102, 'province_id' => 1, 'name' => 'ភ្នំស្រុក'],
            // Add all other districts...
            
            // Phnom Penh (ID: 11)
            ['id' => 1101, 'province_id' => 11, 'name' => 'ជ្រោយចង្វារ'],
            ['id' => 1102, 'province_id' => 11, 'name' => 'ដូនពេញ'],
            // Add all districts for each province
        ];

        // Insert districts
        foreach ($districts as $district) {
            DB::table('district')->updateOrInsert(
                ['id' => $district['id']],
                [
                    'province_id' => $district['province_id'],
                    'name' => $district['name']
                ]
            );
        }

        // Now seed communes
        $this->seedCommunes();
    }

    protected function seedCommunes()
    {
        // This is a simplified example
        $communes = [
            // Mongkol Borei District (ID: 101)
            ['id' => 10101, 'district_id' => 101, 'name' => 'បន្ទាយនាង'],
            // Add all other communes...
        ];

        // Insert communes
        foreach ($communes as $commune) {
            DB::table('commune')->updateOrInsert(
                ['id' => $commune['id']],
                [
                    'district_id' => $commune['district_id'],
                    'name' => $commune['name']
                ]
            );
        }

        // Now seed villages
        $this->seedVillages();
    }

    protected function seedVillages()
    {
        // This is a simplified example
        $villages = [
            // Banteay Neang Commune (ID: 10101)
            ['commune_id' => 10101, 'name' => 'អូរធំ'],
            ['commune_id' => 10101, 'name' => 'ភ្នំ'],
            // Add all other villages...
        ];

        // Insert villages
        foreach ($villages as $village) {
            DB::table('village')->insert([
                'commune_id' => $village['commune_id'],
                'name' => $village['name']
            ]);
        }
    }
}
