<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CityProvinceTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
      // reset province table
      DB::statement('SET FOREIGN_KEY_CHECKS=0');
      DB::table('province')->truncate();

      $created_at = Carbon::now();
      $city_provinces = [
        ['name' => 'Phnom Penh', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Banteay Meanchey', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Battambang', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Kampong Cham', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Kampong Chhnang', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Kampong Speu', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Kampong Thom', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Kampot', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Kandal', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Koh Kong', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Kep', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Kratie', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Mondulkiri', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Oddar Meanchey', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Pailin', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Preah Sihanoukville', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Preah Vihear', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Pursat', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Prey Veng', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Ratanakiri', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Siem Reap', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Stung Treng', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Svay Rieng', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Takeo', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['name' => 'Tbong Khmum', 'created_at' => $created_at, 'updated_at' => $created_at]
      ];

      DB::table('province')->insert($city_provinces);
    }
}
