<?php

namespace Database\Seeders\Concerns;

use RuntimeException;

trait LoadsCambodiaGeography
{
    protected function geographyData(): array
    {
        static $data;

        if ($data !== null) {
            return $data;
        }

        $path = database_path('data/cambodia_gazetteer.json');

        if (! file_exists($path)) {
            throw new RuntimeException("Cambodia geography dataset not found at {$path}. Please download it before seeding.");
        }

        $json = file_get_contents($path);

        if ($json === false) {
            throw new RuntimeException("Unable to read Cambodia geography dataset from {$path}.");
        }

        $decoded = json_decode($json, true);

        if (! is_array($decoded)) {
            throw new RuntimeException("Cambodia geography dataset at {$path} is invalid JSON.");
        }

        return $data = $decoded;
    }

    protected function codeToId(string $code): int
    {
        $normalized = ltrim($code, '0');

        return $normalized === '' ? 0 : (int) $normalized;
    }

    protected function khmerName(array $node): string
    {
        return $node['name']['km'] ?? $node['khmer'] ?? $node['latin'] ?? 'N/A';
    }
}
