<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\UserModel;

class SuperAdminSeeder extends Seeder
{
    public function run()
    {
        // Check if user already exists
        $existingUser = UserModel::where('name', 'neakvorn')->first();
        if ($existingUser) {
            $this->command->info('Super admin user already exists');
            return;
        }

        // Create super admin user
        $user = new UserModel();
        $user->name = 'neakvorn';
        $user->password = bcrypt('12345');
        $user->role = 'super_admin';
        $user->save();

        $this->command->info('Super admin created successfully');
        $this->command->info('Name: neakvorn');
        $this->command->info('Password: 12345');
        $this->command->info('Role: super_admin');
    }
}
