<?php

namespace Database\Seeders;

use Database\Seeders\Concerns\LoadsCambodiaGeography;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class VillageSeeder extends Seeder
{
    use LoadsCambodiaGeography;

    public function run(): void
    {
        $now = now();
        $rows = [];

        foreach ($this->geographyData() as $province) {
            foreach ($province['districts'] ?? [] as $district) {
                foreach ($district['communes'] ?? [] as $commune) {
                    $communeId = $this->codeToId($commune['code']);

                    foreach ($commune['villages'] ?? [] as $village) {
                        $rows[] = [
                            'id'          => $this->codeToId($village['code']),
                            'commune_id'  => $communeId,
                            'name'        => $this->khmerName($village),
                            'created_at'  => $now,
                            'updated_at'  => $now,
                        ];
                    }
                }
            }
        }

        foreach (array_chunk($rows, 500) as $chunk) {
            DB::table('village')->upsert(
                $chunk,
                ['id'],
                ['commune_id', 'name', 'updated_at']
            );
        }
    }
}
