<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class YearEduSeeder extends Seeder
{
    public function run(): void
    {
        DB::table('education_year')->truncate();
        $now = now();

        $data = [
            // បឋមសិក្សា (education_id = 1)
            ['education_id' => 1, 'name' => 'ថ្នាក់ទី១'],
            ['education_id' => 1, 'name' => 'ថ្នាក់ទី២'],
            ['education_id' => 1, 'name' => 'ថ្នាក់ទី៣'],
            ['education_id' => 1, 'name' => 'ថ្នាក់ទី៤'],
            ['education_id' => 1, 'name' => 'ថ្នាក់ទី៥'],
            ['education_id' => 1, 'name' => 'ថ្នាក់ទី៦'],

            // អនុវិទ្យាល័យ (education_id = 2)
            ['education_id' => 2, 'name' => 'ថ្នាក់ទី៧'],
            ['education_id' => 2, 'name' => 'ថ្នាក់ទី៨'],
            ['education_id' => 2, 'name' => 'ថ្នាក់ទី៩'],

            // វិទ្យាល័យ (education_id = 3)
            ['education_id' => 3, 'name' => 'ថ្នាក់ទី១០'],
            ['education_id' => 3, 'name' => 'ថ្នាក់ទី១១'],
            ['education_id' => 3, 'name' => 'ថ្នាក់ទី១២'],

            // បរិញ្ញាបត្រ (education_id = 5)
            ['education_id' => 5, 'name' => 'ឆ្នាំទី១'],
            ['education_id' => 5, 'name' => 'ឆ្នាំទី២'],
            ['education_id' => 5, 'name' => 'ឆ្នាំទី៣'],
            ['education_id' => 5, 'name' => 'ឆ្នាំទី៤'],
        ];

        foreach ($data as $item) {
            $item['created_at'] = $now;
            $item['updated_at'] = $now;
            DB::table('education_year')->insert($item);
        }
    }
}