<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "=== Debug User Counts ===\n";
$users = App\Models\UserModel::with('userInfo')->get();
echo "Total users: " . $users->count() . "\n";

$monks = 0;
$novices = 0;

foreach ($users as $user) {
    if ($user->userInfo && $user->userInfo->monkType) {
        echo "User: " . $user->name . " - Monk Type: " . $user->userInfo->monkType->name . "\n";
        if ($user->userInfo->monkType->name === 'ភិក្ខុ') {
            $monks++;
        } elseif ($user->userInfo->monkType->name === 'សាមណេរ') {
            $novices++;
        }
    }
}

echo "Monks count: " . $monks . "\n";
echo "Novices count: " . $novices . "\n";

echo "\n=== Monk Types ===\n";
$monkTypes = App\Models\MonkType::all();
foreach ($monkTypes as $type) {
    echo "ID: " . $type->id . " - Name: " . $type->name . "\n";
}
