// SUPER SIMPLE KUDI FILTER TEST
console.log('=== KUDI FILTER TEST LOADING ===');

// Wait for DOM
document.addEventListener('DOMContentLoaded', function() {
    console.log('=== DOM LOADED ===');
    
    // Find the select
    const select = document.querySelector('select[name="kudi_id"]');
    console.log('Select found:', !!select);
    
    if (select) {
        console.log('Select options:', select.options.length);
        
        // Add simple change event
        select.addEventListener('change', function() {
            console.log('=== CHANGE EVENT FIRED ===');
            console.log('Selected value:', this.value);
            console.log('Selected text:', this.options[this.selectedIndex].text);
            
            // Simple test - just hide first row
            const firstRow = document.querySelector('tbody tr');
            if (firstRow) {
                if (this.value === '') {
                    firstRow.style.display = '';
                    console.log('First row shown');
                } else {
                    firstRow.style.display = 'none';
                    console.log('First row hidden');
                }
            }
        });
        
        console.log('=== EVENT LISTENER ADDED ===');
    } else {
        console.error('NO SELECT FOUND!');
    }
});

// Also try immediately
console.log('=== IMMEDIATE CHECK ===');
const selectNow = document.querySelector('select[name="kudi_id"]');
console.log('Select found immediately:', !!selectNow);
