@extends('admin.components.app')

@section('content')
    <div class="page" style="max-width: 1200px; margin: 0 auto;">
        <section class="form-section" id="register">
            @php
                $selectedProvince = old('province_id', $userinfo->province_id ?? null);
                $selectedDistrict = old('district_id', $userinfo->district_id ?? null);
                $selectedCommune = old('commune_id', $userinfo->commune_id ?? null);
            @endphp
            <form class="register-form" data-location-form
                action="{{ isset($userinfo) && $userinfo->exists ? route('userinfo.edit', $userinfo->id) : route('userinfo.create') }}"
                method="post" enctype="multipart/form-data">
                @csrf
                @if(isset($userinfo) && $userinfo->exists) @method('Post') @endif

                <article class="student-card">
                    <div class="card-header">
                        <div>
                            <h3>សូមបំពេញព័ត៌មានរបស់អ្នក</h3>
                        </div>
                        <span class="status-pill">សកម្ម</span>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                            <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>អត្តលេខ (ID Number) *</span>
                                <input type="text" name="id_number" value="{{ old('id_number', $userinfo->id_number ?? '') }}"
                                    placeholder="012345" required>
                            </label>
                            <label class="field">
                                <span>ឈ្មោះ (អក្សរខ្មែរ) *</span>
                                <input type="text" name="name_kh" value="{{ old('name_kh', $userinfo->name_kh ?? '') }}"
                                    placeholder="ឧ. សុវណ្ណុ" required>
                            </label>
                            <label class="field">
                                <span>ឈ្មោះ (អក្សរឡាតាំង) *</span>
                                <input type="text" name="name_en" value="{{ old('name_en', $userinfo->name_en ?? '') }}"
                                    placeholder="Sovannou" required>
                            </label>

                            <label class="field radio-field">
                                <span>ភិក្ខុ/សាមណេរ</span>
                                <div class="radio-group">
                                    @foreach($monkTypes as $monkType)
                                        <label class="radio-pill">
                                            <input type="radio" name="monk_type_id" value="{{ $monkType->id }}"
                                                {{ old('monk_type_id', $userinfo->monk_type_id ?? '') == $monkType->id ? 'checked' : '' }}>
                                            <span>{{ $monkType->name }}</span>
                                        </label>
                                    @endforeach
                                </div>
                            </label>

                            @php
                                $dobValue = old('dob', optional($userinfo)->dob ? \Illuminate\Support\Carbon::parse($userinfo->dob)->format('Y-m-d') : null);
                            @endphp
                            <label class="field">
                                <span>ថ្ងៃខែឆ្នាំកំណើត *</span>
                                @include('admin.components.khmer-date-picker-separate', [
                                    'name' => 'dob',
                                    'value' => $dobValue,
                                    'required' => true
                                ])
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ទីកន្លែងកំណើត</h4>
                            <p>សូមបំពេញរាយនាមតាមលំដាប់រដ្ឋបាល</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ខេត្ត/ក្រុង</span>
                                <select name="province_id" data-role="province" data-placeholder="ជ្រើសរើសខេត្ត">
                                    <option value="">{{ __('ជ្រើសរើសខេត្ត') }}</option>
                                    @foreach($provinces as $province)
                                        <option value="{{ $province->id }}"
                                            {{ $selectedProvince == $province->id ? 'selected' : '' }}>
                                            {{ $province->name ?? $province->name_kh ?? $province->name_en }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                            <label class="field">
                                <span>ស្រុក/ខណ្ឌ</span>
                                <select name="district_id" data-role="district"
                                    data-endpoint="{{ url('/locations/provinces/:id/districts') }}"
                                    data-placeholder="ជ្រើសរើសស្រុក"
                                    data-disabled-placeholder="សូមជ្រើសខេត្តជាមុន"
                                    {{ $selectedProvince ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ $selectedProvince ? 'ជ្រើសរើសស្រុក' : 'សូមជ្រើសខេត្តជាមុន' }}
                                    </option>
                                    @foreach($districts as $district)
                                        <option value="{{ $district->id }}"
                                            {{ $selectedDistrict == $district->id ? 'selected' : '' }}>
                                            {{ $district->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                            <label class="field">
                                <span>ឃុំ/សង្កាត់</span>
                                <select name="commune_id" data-role="commune"
                                    data-endpoint="{{ url('/locations/districts/:id/communes') }}"
                                    data-placeholder="ជ្រើសរើសឃុំ"
                                    data-disabled-placeholder="សូមជ្រើសស្រុកជាមុន"
                                    {{ $selectedDistrict ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ $selectedDistrict ? 'ជ្រើសរើសឃុំ' : 'សូមជ្រើសស្រុកជាមុន' }}
                                    </option>
                                    @foreach($communes as $commune)
                                        <option value="{{ $commune->id }}"
                                            {{ $selectedCommune == $commune->id ? 'selected' : '' }}>
                                            {{ $commune->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                            <label class="field">
                                <span>ភូមិ</span>
                                <select name="village_id" data-role="village"
                                    data-endpoint="{{ url('/locations/communes/:id/villages') }}"
                                    data-placeholder="ជ្រើសរើសភូមិ"
                                    data-disabled-placeholder="សូមជ្រើសឃុំជាមុន"
                                    {{ $selectedCommune ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ $selectedCommune ? 'ជ្រើសរើសភូមិ' : 'សូមជ្រើសឃុំជាមុន' }}
                                    </option>
                                    @foreach($villages as $village)
                                        <option value="{{ $village->id }}"
                                            {{ old('village_id', $userinfo->village_id ?? '') == $village->id ? 'selected' : '' }}>
                                            {{ $village->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>

                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានការសិក្សា</h4>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>កម្រិតវប្បធម៌</span>
                                <select name="education_id" data-role="education" data-placeholder="ជ្រើសរើសកម្រិតវប្បធម៌">
                                    <option value="">ជ្រើសរើស</option>
                                    @foreach($educations as $edu)
                                        <option value="{{ $edu->id }}"
                                            {{ old('education_id', $userinfo->education_id ?? '') == $edu->id ? 'selected' : '' }}>
                                            {{ $edu->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                            <label class="field">
                                <span>ឆ្នាំសិក្សា</span>
                                <select name="education_year_id" data-role="education-year"
                                    data-endpoint="{{ url('/education/:id/years') }}"
                                    data-placeholder="ជ្រើសរើសឆ្នាំសិក្សា"
                                    data-disabled-placeholder="សូមជ្រើសកម្រិតវប្បធម៌មានមុន"
                                    {{ old('education_id', $userinfo->education_id ?? '') ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ old('education_id', $userinfo->education_id ?? '') ? 'ជ្រើសរើសឆ្នាំសិក្សា' : 'សូមជ្រើសកម្រិតវប្បធម៌មានមុន' }}
                                    </option>
                                    @foreach($years as $year)
                                        <option value="{{ $year->id }}"
                                            {{ old('education_year_id', $userinfo->education_year_id ?? '') == $year->id ? 'selected' : '' }}>
                                            {{ $year->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                            <label class="field">
                                <span>កុដិ</span>
                                <select name="kudi_id">
                                    <option value="">ជ្រើសរើសកុដិ</option>
                                    @foreach($kudis as $kudi)
                                        <option value="{{ $kudi->id }}"
                                            {{ old('kudi_id', $userinfo->kudi_id ?? '') == $kudi->id ? 'selected' : '' }}>
                                            {{ $kudi->kudi_number }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានមាតាបិតា</h4>
                            <p>បំពេញឈ្មោះ និងមុខរបរមាតាបិតាដោយដៃ</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ឈ្មោះឪពុក </span>
                                <input type="text" name="father_name" value="{{ old('father_name', $userinfo->father_name ?? '') }}"
                                    placeholder="ឧ. លោក សុវណ្ណ">
                            </label>
                            <label class="field">
                                <span>មុខរបរ ឪពុក</span>
                                <input type="text" name="father_job" value="{{ old('father_job', $userinfo->father_job ?? '') }}"
                                    placeholder="ឧ. កសិករ">
                            </label>
                            <label class="field">
                                <span>ឈ្មោះម្ដាយ (បំពេញដោយដៃ)</span>
                                <input type="text" name="mother_name" value="{{ old('mother_name', $userinfo->mother_name ?? '') }}"
                                    placeholder="ឧ. លោកស្រី ផាន">
                            </label>
                            <label class="field">
                                <span>មុខរបរ ម្ដាយ</span>
                                <input type="text" name="mother_job" value="{{ old('mother_job', $userinfo->mother_job ?? '') }}"
                                    placeholder="ឧ. ជាងដេរ">
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>អាសយដ្ឋានបច្ចុប្បន្ន</h4>
                            <p>ទីកន្លែងរស់នៅបច្ចុប្បន្ន និងវត្តដែលស្នាក់នៅ</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ឈ្មោះវត្ត (វត្តនាគវ័ន)</span>
                                <input type="text" name="temple_name" value="{{ old('temple_name', $userinfo->temple_name ?? '') }}"
                                    placeholder="ឧ. វត្តនាគវ័ន">
                            </label>
                            <label class="field">
                                <span>ខេត្ត/ក្រុង (បច្ចុប្បន្ន)</span>
                                <select name="current_province_id" data-role="current-province" data-placeholder="ជ្រើសរើសខេត្ត">
                                    <option value="">{{ __('ជ្រើសរើសខេត្ត') }}</option>
                                    @foreach($provinces as $province)
                                        <option value="{{ $province->id }}"
                                            {{ old('current_province_id', $userinfo->current_province_id ?? '') == $province->id ? 'selected' : '' }}>
                                            {{ $province->name ?? $province->name_kh ?? $province->name_en }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                            <label class="field">
                                <span>ស្រុក/ខណ្ឌ (បច្ចុប្បន្ន)</span>
                                <select name="current_district_id" data-role="current-district"
                                    data-endpoint="{{ url('/locations/provinces/:id/districts') }}"
                                    data-placeholder="ជ្រើសរើសស្រុក"
                                    data-disabled-placeholder="សូមជ្រើសខេត្តជាមុន"
                                    {{ old('current_province_id', $userinfo->current_province_id ?? '') ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ old('current_province_id', $userinfo->current_province_id ?? '') ? 'ជ្រើសរើសស្រុក' : 'សូមជ្រើសខេត្តជាមុន' }}
                                    </option>
                                </select>
                            </label>
                            <label class="field">
                                <span>ឃុំ/សង្កាត់ (បច្ចុប្បន្ន)</span>
                                <select name="current_commune_id" data-role="current-commune"
                                    data-endpoint="{{ url('/locations/districts/:id/communes') }}"
                                    data-placeholder="ជ្រើសរើសឃុំ"
                                    data-disabled-placeholder="សូមជ្រើសស្រុកជាមុន"
                                    {{ old('current_district_id', $userinfo->current_district_id ?? '') ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ old('current_district_id', $userinfo->current_district_id ?? '') ? 'ជ្រើសរើសឃុំ' : 'សូមជ្រើសស្រុកជាមុន' }}
                                    </option>
                                </select>
                            </label>
                            <label class="field">
                                <span>ភូមិ (បច្ចុប្បន្ន)</span>
                                <select name="current_village_id" data-role="current-village"
                                    data-endpoint="{{ url('/locations/communes/:id/villages') }}"
                                    data-placeholder="ជ្រើសរើសភូមិ"
                                    data-disabled-placeholder="សូមជ្រើសឃុំជាមុន"
                                    {{ old('current_commune_id', $userinfo->current_commune_id ?? '') ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ old('current_commune_id', $userinfo->current_commune_id ?? '') ? 'ជ្រើសរើសភូមិ' : 'សូមជ្រើសឃុំជាមុន' }}
                                    </option>
                                </select>
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ទំនាក់ទំនងបន្ថែម</h4>
                        </div>
                        <div class="field-grid">
                            <label class="field field-full">
                                <span>លេខទូរស័ព្ទ</span>
                                <input type="tel" name="phone_number"
                                    value="{{ old('phone_number', $userinfo->phone_number ?? '') }}"
                                    placeholder="លេខទូរស័ព្ទ">
                            </label>
                            <div class="field field-full file-field">
                                <span>រូបថតសិស្ស</span>
                                @if(isset($userinfo) && $userinfo->image)
                                    <div style="margin-bottom: 0.75rem;">
                                        <img src="{{ asset('storage/' . $userinfo->image) }}" alt="{{ $userinfo->name_kh ?? '' }}" style="width: 100px; height: 100px; object-fit: cover; border-radius: 12px; border: 2px solid #e5e7eb;">
                                    </div>
                                @endif
                                <input type="file" name="image" id="image-input" accept="image/*" {{ isset($userinfo) && $userinfo->image ? '' : 'required' }}>
                            </div>
                        </div>
                    </div>
                </article>

                <div class="form-footer">
                    <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
                    <button class="btn btn-primary" type="submit">{{ isset($userinfo) && $userinfo->exists ? 'កែប្រែ' : 'រក្សាទុក' }}</button>
                </div>
            </form>
        </section>
    </div>

@push('script')
    @include('admin.components.location-select-script')
@endpush
