<div class="user-detail-container ">
    <!-- User Profile Header -->
    <div class="user-profile-header">
        <div class="user-profile-image-container">
            @if($info->image)
                <img src="{{ asset('storage/' . $info->image) }}" 
                     alt="{{ $info->name_kh }}" 
                     class="user-profile-image"
                     onclick="openUserImageModal(this, '{{ $info->name_kh }}')"
                     style="cursor: pointer;">
            @else
                <div class="user-profile-image d-flex align-items-center justify-content-center bg-light">
                    <i class="fas fa-user fa-3x text-muted"></i>
                </div>
            @endif
        </div>
        
        <div class="user-profile-info flex-grow-1">
            <h3>{{ $info->name_kh }}</h3>
            <div class="user-meta">
                <div class="user-meta-item">
                    <i class="fas fa-id-card"></i>
                    <span>{{ $info->id_number }}</span>
                </div>
                @if($info->phone_number)
                <div class="user-meta-item">
                    <i class="fas fa-phone"></i>
                    <span>{{ $info->phone_number }}</span>
                </div>
                @endif
                @if($info->monkType)
                <div class="user-meta-item">
                    <i class="fas fa-pray"></i>
                    <span>{{ $info->monkType->name }}</span>
                </div>
                @endif
                @if($info->kudi)
                <div class="user-meta-item">
                    <i class="fas fa-home"></i>
                    <span> {{ $info->kudi->kudi_number }}</span>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Personal Information Section -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-user me-2"></i>
            ព័ត៌មានផ្ទាល់ខ្លួន
        </h6>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-user"></i>
                    ឈ្មោះ (ខ្មែរ):
                </div>
                <div class="info-value">{{ $info->name_kh }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-user"></i>
                    ឈ្មោះ (ឡាតាំង):
                </div>
                <div class="info-value">{{ $info->name_en }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-id-card"></i>
                    អត្តលេខ:
                </div>
                <div class="info-value">{{ $info->id_number }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-phone"></i>
                    លេខទូរស័ព្ទ:
                </div>
                <div class="info-value">{{ $info->phone_number ?? '—' }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-birthday-cake"></i>
                    ថ្ងៃកំណើត:
                </div>
                <div class="info-value">
                    @if($info->dob)
                        {{ \Carbon\Carbon::parse($info->dob)->format('d/m/Y') }}
                    @else
                        —
                    @endif
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-pray"></i>
                    ភិក្ខុ/សាមណេរ:
                </div>
                <div class="info-value">{{ optional($info->monkType)->name ?? '—' }}</div>
            </div>
        </div>
    </div>

    <!-- Education Section -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-graduation-cap me-2"></i>
            ព័ត៌មានការសិក្សា
        </h6>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-graduation-cap"></i>
                    កម្រិតវប្បធម៌:
                </div>
                <div class="info-value">{{ optional($info->education)->name ?? '—' }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-calendar-alt"></i>
                    ឆ្នាំសិក្សា:
                </div>
                <div class="info-value">{{ optional($info->educationYear)->name ?? '—' }}</div>
            </div>
        </div>
    </div>

    <!-- Kudi Information -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-home me-2"></i>
            ព័ត៌មានកុដិ
        </h6>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-home"></i>
                    កុដិលេខ:
                </div>
                <div class="info-value">{{ optional($info->kudi)->kudi_number ?? '—' }}</div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-vihara"></i>
                    វត្តឈ្មោះ:
                </div>
                <div class="info-value">{{ $info->temple_name ?? '—' }}</div>
            </div>
        </div>
    </div>

    <!-- Family Information -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-users me-2"></i>
            ព័ត៌មានគ្រួសារ
        </h6>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-user-tie"></i>
                    ឈ្មោះឪពុក:
                </div>
                <div class="info-value">
                    @if($info->father_id && $info->father)
                        {{ $info->father->name }}
                    @elseif($info->father_name)
                        {{ $info->father_name }}
                    @else
                        —
                    @endif
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-briefcase"></i>
                    មុខរបរឪពុក:
                </div>
                <div class="info-value">
                    @if($info->father_id && $info->father)
                        {{ $info->father->job ?? '—' }}
                    @else
                        {{ $info->father_job ?? '—' }}
                    @endif
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-user"></i>
                    ឈ្មោះម្ដាយ:
                </div>
                <div class="info-value">
                    @if($info->mother_id && $info->mother)
                        {{ $info->mother->name }}
                    @elseif($info->mother_name)
                        {{ $info->mother_name }}
                    @else
                        —
                    @endif
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-briefcase"></i>
                    មុខរបរម្ដាយ:
                </div>
                <div class="info-value">
                    @if($info->mother_id && $info->mother)
                        {{ $info->mother->job ?? '—' }}
                    @else
                        {{ $info->mother_job ?? '—' }}
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Address Information -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-map-marker-alt me-2"></i>
            ព័ត៌មានអាសយដ្ឋាន
        </h6>
        
        <!-- Original Address -->
        <div class="address-card">
            <h6>
                <i class="fas fa-home me-2"></i>
                អាសយដ្ឋានកំណើត
            </h6>
            <div class="address-text">
                @if($info->village || $info->commune || $info->district || $info->province)
                    {{ optional($info->village)->name ?? '' }}
                    @if($info->village && $info->commune), @endif
                    {{ optional($info->commune)->name ?? '' }}
                    @if($info->commune && $info->district), @endif
                    {{ optional($info->district)->name ?? '' }}
                    @if($info->district && $info->province), @endif
                    {{ optional($info->province)->name ?? '' }}
                @else
                    —
                @endif
            </div>
        </div>

        <!-- Current Address -->
        <div class="address-card">
            <h6>
                <i class="fas fa-map-pin me-2"></i>
                អាសយដ្ឋានបច្ចុប្បន្ន
            </h6>
            <div class="address-text">
                @if($info->currentVillage || $info->currentCommune || $info->currentDistrict || $info->currentProvince)
                    {{ optional($info->currentVillage)->name ?? '' }}
                    @if($info->currentVillage && $info->currentCommune), @endif
                    {{ optional($info->currentCommune)->name ?? '' }}
                    @if($info->currentCommune && $info->currentDistrict), @endif
                    {{ optional($info->currentDistrict)->name ?? '' }}
                    @if($info->currentDistrict && $info->currentProvince), @endif
                    {{ optional($info->currentProvince)->name ?? '' }}
                @else
                    —
                @endif
            </div>
        </div>
    </div>
</div>
