@extends('admin.components.app')

@section('content')
    <div class="page">
        <article class="student-card">
            <div class="card-header">
                <div>
                    <h3>ព័ត៌មានលម្អិត | {{ $userinfo->name_kh }}</h3>
                </div>
                <div class="header-buttons">
                    <a href="{{ route('profile.download', $userinfo->id) }}" target="_blank" class="btn btn-primary">
                        📥 ទាញយក 
                    </a>
                    <a href="{{ route('profile.edit', $userinfo->id) }}" class="btn btn-secondary">
                        ✏ កែប្រែ
                    </a>
                </div>
            </div>

            <!-- Profile Photo Section -->
            <div class="profile-photo-section">
                @if($userinfo->image)
                    <img src="{{ asset('storage/users/images/' . $userinfo->image) }}" alt="{{ $userinfo->name_kh }}" class="profile-photo">
                @else
                    <img src="https://ui-avatars.com/api/?name={{ urlencode($userinfo->name_kh) }}&background=4c5cff&color=fff&size=150" alt="{{ $userinfo->name_kh }}" class="profile-photo">
                @endif
            </div>

            <!-- Personal Information -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                    <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                </div>
                <div class="field-grid">
                    <div class="field">
                        <span>អត្តលេខ (ID Number)</span>
                        <div class="field-value">{{ $userinfo->id_number ?? '-' }}</div>
                    </div>
                    <div class="field">
                        <span>ឈ្មោះ (អក្សរខ្មែរ)</span>
                        <div class="field-value">{{ $userinfo->name_kh }}</div>
                    </div>
                    <div class="field">
                        <span>ឈ្មោះ (អក្សរឡាតាំង)</span>
                        <div class="field-value">{{ $userinfo->name_en ?? '-' }}</div>
                    </div>
                    <div class="field">
                        <span>ភិក្ខុ/សាមណេរ</span>
                        <div class="field-value">{{ optional($userinfo->monkType)->name ?? '-' }}</div>
                    </div>
                    @if($userinfo->dob)
                        <div class="field">
                            <span>ថ្ងៃខែឆ្នាំកំណើត</span>
                            <div class="field-value">{{ \Carbon\Carbon::parse($userinfo->dob)->format('d/m/Y') }}</div>
                        </div>
                    @endif
                    @if($userinfo->phone_number)
                        <div class="field">
                            <span>លេខទូរស័ព្ទ</span>
                            <div class="field-value">{{ $userinfo->phone_number }}</div>
                        </div>
                    @endif
                    @if($userinfo->kudi)
                        <div class="field">
                            <span>កុដិ</span>
                            <div class="field-value">{{ $userinfo->kudi->kudi_number }}</div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Birth Address -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ទីកន្លែងកំណើត</h4>
                    <p>សូមបំពេញរាយនាមតាមលំដាប់រដ្ឋបាល</p>
                </div>
                <div class="field-grid">
                    @if(optional($userinfo->province)->name)
                        <div class="field">
                            <span>ខេត្ត/ក្រុង</span>
                            <div class="field-value">{{ $userinfo->province->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->district)->name)
                        <div class="field">
                            <span>ស្រុក/ខណ្ឌ</span>
                            <div class="field-value">{{ $userinfo->district->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->commune)->name)
                        <div class="field">
                            <span>ឃុំ/សង្កាត់</span>
                            <div class="field-value">{{ $userinfo->commune->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->village)->name)
                        <div class="field">
                            <span>ភូមិ</span>
                            <div class="field-value">{{ $userinfo->village->name }}</div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Current Address -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>អាសយដ្ឋានបច្ចុប្បន្ន</h4>
                    <p>ទីកន្លែងបច្ចុប្បន្នរបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    @if($userinfo->temple_name)
                        <div class="field">
                            <span>ឈ្មោះវត្ត</span>
                            <div class="field-value">{{ $userinfo->temple_name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->currentProvince)->name)
                        <div class="field">
                            <span>ខេត្ត/ក្រុង</span>
                            <div class="field-value">{{ $userinfo->currentProvince->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->currentDistrict)->name)
                        <div class="field">
                            <span>ស្រុក/ខណ្ឌ</span>
                            <div class="field-value">{{ $userinfo->currentDistrict->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->currentCommune)->name)
                        <div class="field">
                            <span>ឃុំ/សង្កាត់</span>
                            <div class="field-value">{{ $userinfo->currentCommune->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->currentVillage)->name)
                        <div class="field">
                            <span>ភូមិ</span>
                            <div class="field-value">{{ $userinfo->currentVillage->name }}</div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Parent Information -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ព័ត៌មានមាតាបិតា</h4>
                    <p>ព័ត៌មានអំពីមាតាបិតារបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    @if($userinfo->father_name)
                        <div class="field">
                            <span>ឈ្មោះឪពុក</span>
                            <div class="field-value">{{ $userinfo->father_name }}</div>
                            @if($userinfo->father_job)
                                <div class="field-value" style="font-size: 0.9rem; color: var(--muted); margin-top: 0.25rem;">
                                    មុខរបរ: {{ $userinfo->father_job }}
                                </div>
                            @endif
                        </div>
                    @endif
                    @if($userinfo->mother_name)
                        <div class="field">
                            <span>ឈ្មោះម្តាយ</span>
                            <div class="field-value">{{ $userinfo->mother_name }}</div>
                            @if($userinfo->mother_job)
                                <div class="field-value" style="font-size: 0.9rem; color: var(--muted); margin-top: 0.25rem;">
                                    មុខរបរ: {{ $userinfo->mother_job }}
                                </div>
                            @endif
                        </div>
                    @endif
                </div>
            </div>

            <!-- Education Information -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ព័ត៌មានការសិក្សា</h4>
                    <p>កម្រិតវប្បធម៌និងការសិក្សារបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    @if(optional($userinfo->education)->name)
                        <div class="field">
                            <span>កម្រិតវប្បធម៌</span>
                            <div class="field-value">{{ $userinfo->education->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->educationYear)->name)
                        <div class="field">
                            <span>ឆ្នាំសិក្សា</span>
                            <div class="field-value">{{ $userinfo->educationYear->name }}</div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Action Buttons -->
            
        </article>
    </div>

    <style>
        /* Load the form-style CSS */
        @import url('{{ asset('assets/style/profile-form-style.css') }}');
        
        /* Header Buttons Alignment */
        .header-buttons {
            display: flex;
            gap: 0.75rem;
            align-items: center;
        }
    </style>
@endsection
