@php
    $name = $name ?? 'datetime';
    $value = $value ?? null;
    $required = $required ?? false;
    $placeholder = $placeholder ?? 'ជ្រើសរើសកាលបរិច្ឆេទ';
    $disabled = $disabled ?? false;
    $class = $class ?? 'form-control';
    $enableTime = $enableTime ?? true;
    $enableDate = $enableDate ?? true;
    $minDate = $minDate ?? '1940-01-01';
    $maxDate = $maxDate ?? 'today';
    $defaultDate = $defaultDate ?? null;
@endphp

<!-- Khmer Date Time Picker Component -->
<label class="field">
    <span>{{ $label ?? 'កាលបរិច្ឆេទ' }}{{ $required ? ' *' : '' }}</span>
    <input 
        type="text" 
        name="{{ $name }}" 
        value="{{ $value }}"
        placeholder="{{ $placeholder }}"
        class="{{ $class }} khmer-datetime-picker"
        {{ $required ? 'required' : '' }}
        {{ $disabled ? 'disabled' : '' }}
        readonly
    >
</label>

@push('scripts')
    @once
        <script>
        // Khmer Date Time Picker Configuration
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize all Khmer datetime pickers
            const dateTimePickers = document.querySelectorAll('.khmer-datetime-picker');
            
            dateTimePickers.forEach(function(picker) {
                const config = {
                    locale: "km",
                    static: true,
                    monthSelectorType: 'static',
                    clickOpens: true,
                    disableMobile: true,
                    onClose: function(selectedDates, dateStr, instance) {
                        // Trigger change event for form validation
                        const event = new Event('change', { bubbles: true });
                        instance.input.dispatchEvent(event);
                    },
                    onOpen: function(selectedDates, dateStr, instance) {
                        // Add Khmer styling to calendar
                        const calendarContainer = instance.calendarContainer;
                        calendarContainer.style.fontFamily = 'Kantumruy Pro, system-ui, sans-serif';
                        
                        // Style the time grid if time is enabled
                        if (config.enableTime) {
                            const timeGrid = calendarContainer.querySelector('.flatpickr-time');
                            if (timeGrid) {
                                timeGrid.style.fontFamily = 'Kantumruy Pro, system-ui, sans-serif';
                                timeGrid.style.fontSize = '14px';
                            }
                            
                            // Style hour and minute inputs
                            const hourInput = calendarContainer.querySelector('.flatpickr-hour');
                            const minuteInput = calendarContainer.querySelector('.flatpickr-minute');
                            
                            if (hourInput) {
                                hourInput.style.fontFamily = 'Kantumruy Pro, system-ui, sans-serif';
                                hourInput.placeholder = 'មោោ';
                            }
                            
                            if (minuteInput) {
                                minuteInput.style.fontFamily = 'Kantumruy Pro, system-ui, sans-serif';
                                minuteInput.placeholder = 'នាទី';
                            }
                        }
                    }
                };
                
                // Date configuration
                if ({{ $enableDate ? 'true' : 'false' }}) {
                    config.dateFormat = {{ $enableTime ? '"d/m/Y H:i"' : '"d/m/Y"' }};
                    config.minDate = "{{ $minDate }}";
                    config.maxDate = "{{ $maxDate }}";
                    @if($defaultDate)
                    config.defaultDate = "{{ $defaultDate }}";
                    @endif
                }
                
                // Time configuration
                if ({{ $enableTime ? 'true' : 'false' }}) {
                    config.enableTime = true;
                    config.noCalendar = {{ $enableDate ? 'false' : 'true' }};
                    config.time_24hr = true;
                    config.hourIncrement = 1;
                    config.minuteIncrement = 5;
                    config.minTime = "00:00";
                    config.maxTime = "23:59";
                    config.defaultHour = 8;
                    config.defaultMinute = 0;
                }
                
                flatpickr(picker, config);
            });
        });
        </script>
        
        <style>
        /* Khmer Date Time Picker Styles */
        .khmer-datetime-picker {
            cursor: pointer;
            background-color: #fff;
        }
        
        .khmer-datetime-picker:hover {
            border-color: #4c5cff;
        }
        
        .flatpickr-calendar {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-time {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-time .numInputWrapper {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-time .numInputWrapper span {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-time .flatpickr-am-pm {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-months .flatpickr-month,
        .flatpickr-weekdays,
        .flatpickr-days .flatpickr-day {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-current-month .numInputWrapper {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-weekday {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        </style>
    @endonce
@endpush
