<!-- Khmer Picker Usage Examples -->

<!-- Example 1: Time Only -->
@include('admin.components.khmer-time-picker', [
    'name' => 'start_time',
    'label' => 'ម៉ោងចាប់ផ្ដើម',
    'placeholder' => 'ជ្រើសរើសម៉ោងចាប់ផ្ដើម',
    'required' => true,
    'value' => old('start_time', '08:00')
])

<!-- Example 2: Date Only -->
@include('admin.components.khmer-datetime-picker', [
    'name' => 'birth_date',
    'label' => 'កាលបរិច្ឆេទកំណើត',
    'placeholder' => 'ជ្រើសរើសកាលបរិច្ឆេទកំណើត',
    'enableTime' => false,
    'enableDate' => true,
    'required' => true,
    'value' => old('birth_date'),
    'minDate' => '1940-01-01',
    'maxDate' => 'today'
])

<!-- Example 3: Date and Time -->
@include('admin.components.khmer-datetime-picker', [
    'name' => 'appointment_datetime',
    'label' => 'កាលបរិច្ឆេទកម្មង់',
    'placeholder' => 'ជ្រើសរើសកាលបរិច្ឆេទនិងម៉ោង',
    'enableTime' => true,
    'enableDate' => true,
    'required' => true,
    'value' => old('appointment_datetime'),
    'minDate' => 'today',
    'defaultDate' => 'today'
])

<!-- Example 4: Time with Custom Class -->
@include('admin.components.khmer-time-picker', [
    'name' => 'end_time',
    'label' => 'ម៉ោងបញ្ចប់',
    'placeholder' => 'ជ្រើសរើសម៉ោងបញ្ចប់',
    'class' => 'form-control custom-time-picker',
    'required' => false,
    'value' => old('end_time', '17:00')
])

<!-- Example 5: Disabled Picker -->
@include('admin.components.khmer-datetime-picker', [
    'name' => 'created_at',
    'label' => 'កាលបរិច្ឆេទបង្កើត',
    'placeholder' => 'កាលបរិច្ឆេទបង្កើត',
    'enableTime' => true,
    'enableDate' => true,
    'disabled' => true,
    'value' => now()->format('d/m/Y H:i')
])
