@extends('admin.components.app')
@section('content')
    <div class="page">
        <section class="form-section" id="register">
            <form class="register-form"
                action="{{ isset($user) ? route('user.edit', $user->id) : route('user.create') }}"
                method="post" enctype="multipart/form-data">
                @csrf
                <article class="student-card">
                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                            <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                        </div>
                        <div class="field-grid">

                            <label class="field">
                                <span>ឈ្មោះ (អក្សរខ្មែរ)</span>
                                <input type="text" name="name" value="{{ old('name', $user->name ?? '') }}">
                            </label>
                            <label class="field">
                                <span>អាស័យដ្ឋានអ៊ីម៉ែល</span>
                                <input type="email" name="email" value="{{ old('email', $user->email ?? '') }}">
                            </label>
                             <label class="field">
                                <span>ពាក្យសម្ងាត់</span>
                                <input type="password" name="password" value="{{ old('email', $user->email ?? '') }}">
                            </label>
                            <label class="field">
                                <span>តួនាទី</span>
                                <input type="text" name="role" value="{{ old('role', $user->role ?? '') }}">
                            </label>
                            @if(isset($user) && $user->image)
                                <div class="field">
                                    <span>Current Image:</span>
                                    <img src="{{ Storage::url($user->image) }}" alt="" style="width: 100px; height: 100px;">
                                </div>
                            @endif
                            <label class="field">
                                <span>រូបភាព</span>
                                <input type="file" name="image">
                            </label>

                        </div>
                    </div>

                    <div class="form-footer">
                        <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
                        <button class="btn btn-primary" type="submit">{{ isset($user) ? 'កែប្រែ' : 'រក្សាទុក' }}</button>
                    </div>
                </article>
            </form>
        </section>
    </div>
@endsection

