@extends('admin.components.app')
@section('content')
    <div class="page">
       <form class="register-form"
      action="{{ isset($dis->id) ? route('district.edit', $dis->id) : route('district.create') }}"
      method="post">
    @csrf

    <article class="student-card">
        <div class="fieldset">
            <div class="field-grid">

                <label class="field">
                    <span>ឈ្មោះស្រុក (District Name)</span>
                    <input type="text" name="name" value="{{ old('name', $dis->name ?? '') }}" required>
                </label>

                <div class="field">
                    <span>ជ្រើសរើសខេត្ត (Select Province)</span>
                    <select name="province_id" class="form-control" required>
                        <option value="">-- Select Province --</option>
                        @foreach ($pro as $p)
                            <option value="{{ $p->id }}"
                                {{ (old('province_id', $dis->province_id ?? '') == $p->id) ? 'selected' : '' }}>
                                {{ $p->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

            </div>
        </div>

        <div class="form-footer">
            <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
            <button class="btn btn-primary" type="submit">
                {{ isset($dis->id) ? 'កែប្រែ (Update)' : 'រក្សាទុក (Save)' }}
            </button>
        </div>
    </article>
</form>
    </div>
@endsection
