@extends('admin.components.app')
@section('content')

    
    <div class="page">
        <section class="form-section">
            <div class="card mt-3 border-0 shadow-none bg-transparent">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="mb-0">បញ្ជីអ្នកប្រើប្រាស់</h3>
                    <a href="{{ route('district.create') }}" class="btn btn-primary">បង្កើតថ្មី</a>
                </div>

                <div class="table-wrapper">
                    <table class="table table-hover align-middle mb-0 checkbox-all">
                        <thead>
                            <tr>
                                <th>ល.រ</th>
                                <th>ខេត្ត</th>
                                 <th>ស្រុក</th>
                                <th class="text-end">សកម្មភាព</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($dis as $index => $district)
                                <tr>
                                    <th>{{ $dis->firstItem() + $index }}</th>
                                     <td>{{ $district->province->name }}</td>
                                    <td>{{ $district->name }}</td>


                                    @include('admin.district.action', ['dis' => $district])
                                </tr>
                            @endforeach
                            
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="4" class="text-center">
                                    {{ $dis->links('components.pagination.three-links') }}
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </section>
    </div>

@endsection
