@extends('admin.components.app')
@section('content')

    <div class="page">
        <section class="form-section">
            <div class="card mt-3 border-0 shadow-none bg-transparent">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="mb-0">បញ្ជីអ្នកប្រើប្រាស់</h3>
                    <a href="{{ route('father.create') }}" class="btn btn-primary">បង្កើតថ្មី</a>
                </div>

                <div class="table-wrapper">
                    <table class="table table-hover align-middle mb-0 checkbox-all" id="datatable_1">
                        <thead>
                            <tr>
                                <th>ល.រ</th>
                                <th>ឈ្មោះ</th>
                                <th>ការងារ</th>
                                <th>ខេត្ត</th>
                                <th>ក្រុង</th>
                                <th>ឃុំ</th>
                                <th>ភូមិ</th>

                                <th class="text-end">សកម្មភាព</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($father as $i => $father)
                                <tr>
                                    <th>{{ $i + 1 }}</th>
                                    <td class="ps-0">
                                        {{ $father->name }}
                                    </td>
                                    <td>{{ $father->job }}</td>
                                    <td>{{ $father->province->name }}</td>
                                    <td>{{ $father->district->name }}</td>
                                    <td>{{ $father->commune->name }}</td>
                                    <td>{{ $father->village->name }}</td>
                                   
                                    @include('admin.father.action', ['father' => $father])
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>

@endsection
