@extends('admin.components.app')
@section('content')

    <div class="page">
        <section class="form-section">
            <div class="card mt-3 border-0 shadow-none bg-transparent">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="mb-0">បញ្ជីអ្នកប្រើប្រាស់</h3>
                    <a href="{{ route('province.create') }}" class="btn btn-primary">បង្កើតថ្មី</a>
                </div>

                <div class="table-wrapper">
                    <table class="table table-hover align-middle mb-0 checkbox-all">
                        <thead>
                            <tr>
                                <th>ល.រ</th>
                                <th>ខេត្ត</th>
                                <th class="text-end">សកម្មភាព</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($pro as $index => $province)
                                <tr>
                                    <th>{{ $pro->firstItem() + $index }}</th>
                                    <td>{{ $province->name }}</td>
                                    @include('admin.province.action', ['pro' => $province])
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="text-center mt-4">
                    {{ $pro->links('components.pagination.three-links') }}
                </div>
            </div>
        </section>
    </div>

@endsection
