@extends('admin.components.app')
@section('content')

@push('script')
    <script src="{{ asset('assets/js/kudi-filter.js') }}"></script>
    <script>
        // User Detail Modal Function
        function showUserDetailModal(userId) {
            console.log('showUserDetailModal called with userId:', userId);
            event.preventDefault();
            event.stopPropagation();
            
            // Show modal
            const modal = new bootstrap.Modal(document.getElementById('userDetailModal'));
            modal.show();
            
            // Reset content
            document.getElementById('userDetailContent').innerHTML = `
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-2">កំពុងផ្ទុកព័ត៌មាន...</p>
                </div>
            `;
            
            // Fetch user details via AJAX
            console.log('Fetching user details for ID:', userId);
            fetch(`/admin/user/${userId}/detail`, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => {
                console.log('Response received:', response.status);
                return response.json();
            })
            .then(data => {
                console.log('Data received:', data);
                if (data.success) {
                    document.getElementById('userDetailContent').innerHTML = data.html;
                } else {
                    document.getElementById('userDetailContent').innerHTML = `
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            ${data.message || 'មិនអាចផ្ទុកព័ត៌មានបានទេ។'}
                        </div>
                    `;
                }
            })
            .catch(error => {
                console.error('Error fetching user details:', error);
                document.getElementById('userDetailContent').innerHTML = `
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        មានបញ្ហាក្នុងការផ្ទុកព័ត៌មាន។ សូមព្យាយាមម្ដងទៀត។
                    </div>
                `;
            });
        }

        // Make sure function is globally available
        window.showUserDetailModal = showUserDetailModal;
        
        // Test function
        function testModal() {
            console.log('testModal called');
            const modal = new bootstrap.Modal(document.getElementById('userDetailModal'));
            modal.show();
        }
        
        window.testModal = testModal;
        
        // User Image Modal Functions
        function openUserImageModal(imgElement, userName) {
            const modal = document.getElementById('userImageModal');
            const modalImage = document.getElementById('userModalImage');

            modalImage.src = imgElement.src;
            modalImage.alt = userName;
            modal.style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }

        function closeUserImageModal() {
            const modal = document.getElementById('userImageModal');
            modal.style.display = 'none';
            document.body.style.overflow = 'auto';
        }

        // Make functions globally available
        window.openUserImageModal = openUserImageModal;
        window.closeUserImageModal = closeUserImageModal;
        
        // Add event listeners for user detail buttons
        document.addEventListener('DOMContentLoaded', function() {
            console.log('DOM loaded, setting up event listeners');
            
            // Handle user detail buttons
            const userDetailButtons = document.querySelectorAll('.user-detail-btn');
            console.log('Found user detail buttons:', userDetailButtons.length);
            
            userDetailButtons.forEach(button => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    const userId = this.getAttribute('data-user-id');
                    console.log('User detail button clicked, ID:', userId);
                    
                    showUserDetailModal(userId);
                });
            });

            // Handle escape key for modals
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    closeUserImageModal();
                }
            });
        });
    </script>
@endpush

    <div class="page">
        <section class="form-section">
            <div class="card mt-3 border-0 shadow-none bg-transparent">
                @include('admin.components.kudi-filter', [
                    'title' => 'បញ្ជីអ្នកគ្រប់គ្រង',
                    'subtitle' => 'រើសកុដិដើម្បីមើលអ្នកប្រើប្រាស់ដែលពាក់ព័ន្ធ',
                    'filterAction' => route('user.index'),
                    'kudis' => $kudis,
                    'selectedKudiId' => $selectedKudiId,
                    'createRoute' => route('user.create'),
                    'createLabel' => 'បង្កើតអ្នកប្រើប្រាស់ថ្មី'
                ])

                <div class="kudi-table-card ">
                    <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0 checkbox-all kudi-table" id="datatable_1">
                        <thead>
                            <tr>
                                <th>ល.រ</th>
                                <th>រូបភាព</th>
                                <th>ឈ្មោះ</th>
                                <th>កុដិលេខ</th>
                                <th>តួនាទី</th>
                                <th class="text-end">សកម្មភាព</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $i => $user)
                                <tr data-kudi-id="{{ $user->kudi_id ?? '' }}">
                                    <th>{{ $i + 1 }}</th>
                                    <td class="ps-0">
                                        <img src="{{ $user->image ? asset('storage/' . $user->image) : asset('assets/image/—Pngtree—kon chat buddhism_6948880.png') }}" 
                                             alt="{{ $user->name }}"
                                             class="avatar-fit"
                                             onclick="openUserImageModal(this, '{{ $user->name }}')"
                                             style="cursor: pointer;">
                                    </td>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ optional($user->kudi)->kudi_number ?? '—' }}</td>
                                    <td>{{ $user->role }}</td>
                                    @include('admin.user.action', ['user' => $user])
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                    <div class="kudi-table-glow"></div>
                </div>
            </div>
        </section>

        
        <!-- User Detail Modal -->
        <div class="modal fade" id="userDetailModal" tabindex="-1" aria-labelledby="userDetailModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="userDetailModalLabel">ព័ត៌មានលម្អិតអ្នកប្រើប្រាស់</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div id="userDetailContent">
                            <div class="text-center py-4">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <p class="mt-2">កំពុងផ្ទុកព័ត៌មាន...</p>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">បិទ</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- User Image Modal -->
        <div id="userImageModal" class="user-image-modal mt-4" onclick="closeUserImageModal()">
            <div class="user-modal-card" onclick="event.stopPropagation()">
                <div class="user-modal-header">
                    <h5 class="user-modal-title">
                        <i class="fas fa-image me-2"></i>
                        ូបភាពអ្នកប្រើប្រាស់
                    </h5>
                    <button type="button" class="user-modal-close" onclick="closeUserImageModal()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="user-modal-body">
                    <img id="userModalImage" src="" alt="User Image" class="user-modal-image">
                </div>
                <div class="user-modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="closeUserImageModal()">
                        <i class="fas fa-times me-2"></i>បិទ
                    </button>
                </div>
            </div>
        </div>
    </div>

@endsection

@pushOnce('css', 'kudi-table-styles')
    <style>
        .kudi-table-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 32px;
            padding: 1.5rem 1.75rem 2rem;
            box-shadow: 0 25px 60px rgba(89, 92, 150, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.6);
            position: relative;
            overflow: hidden;
        }

        .kudi-table-card .table-responsive {
            max-height: 70vh;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .kudi-table {
            border-collapse: separate;
            border-spacing: 0 12px;
            width: 100%;
            table-layout: fixed;
            min-width: 900px;
        }

        .kudi-table thead th {
            border: none;
            font-size: 0.78rem;
            text-transform: uppercase;
            letter-spacing: 0.08em;
            color: #6c7798;
            font-weight: 600;
        }

        .kudi-table tbody tr {
            background: #fefefe;
            box-shadow: 0 10px 25px rgba(118, 127, 180, 0.12);
            border-radius: 18px;
        }

        .kudi-table tbody tr td,
        .kudi-table tbody tr th {
            border: none;
            vertical-align: middle;
            white-space: normal;
            word-break: break-word;
        }

        .kudi-table tbody tr td:first-child,
        .kudi-table tbody tr th:first-child {
            border-top-left-radius: 18px;
            border-bottom-left-radius: 18px;
        }

        .kudi-table tbody tr td:last-child {
            border-top-right-radius: 18px;
            border-bottom-right-radius: 18px;
        }

        .kudi-table tbody tr:hover {
            transform: translateY(-2px);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
            box-shadow: 0 20px 35px rgba(93, 113, 182, 0.2);
        }

        .kudi-table-card .avatar-fit {
            width: 56px;
            height: 56px;
            border-radius: 14px;
            object-fit: cover;
            border: 2px solid rgba(255, 255, 255, 0.8);
            box-shadow: 0 6px 14px rgba(44, 62, 80, 0.2);
        }

        .kudi-table-glow {
            position: absolute;
            left: 10%;
            right: 10%;
            bottom: 0.5rem;
            height: 6px;
            border-radius: 999px;
            background: linear-gradient(90deg, #7b9bff, #f18bd9);
            opacity: 0.6;
        }

        @media (max-width: 768px) {
            .kudi-table-card {
                padding: 1rem;
            }

            .kudi-table {
                border-spacing: 0 8px;
            }
        }

        /* User Image Modal Styles */
        .user-image-modal {
            display: none;
            position: fixed;
            z-index: 99999;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            backdrop-filter: blur(5px);
            align-items: center;
            justify-content: center;
        }

        .user-modal-card {
            position: relative;
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            margin: auto;
            padding: 0;
            border: 1px solid rgba(0, 0, 0, 0.1);
            border-radius: 16px;
            width: 95%;
            max-width: 600px;
            max-height: 90vh;
            overflow: hidden;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            animation: slideUp 0.4s ease;
            display: flex;
            flex-direction: column;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(50px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        .user-modal-header {
            padding: 1rem 1.5rem;
            border-bottom: 1px solid #e9ecef;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 16px 16px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 4px 20px rgba(102, 126, 234, 0.3);
        }

        .user-modal-title {
            margin: 0;
            font-size: 1.25rem;
            font-weight: 600;
            display: flex;
            align-items: center;
        }

        .user-modal-close {
            color: rgba(255, 255, 255, 0.8);
            font-size: 1.25rem;
            font-weight: bold;
            cursor: pointer;
            background: rgba(255, 255, 255, 0.1);
            border: none;
            padding: 0.25rem;
            border-radius: 50%;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }

        .user-modal-close:hover {
            color: white;
            background: rgba(255, 255, 255, 0.2);
            transform: rotate(90deg);
        }

        .user-modal-body {
            padding: 2rem;
            display: flex;
            justify-content: center;
            align-items: center;
            background: #ffffff;
            flex: 1;
        }

        .user-modal-image {
            max-width: 100%;
            max-height: 60vh;
            object-fit: contain;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
            border: 4px solid #667eea;
            transition: transform 0.3s ease;
        }

        .user-modal-image:hover {
            transform: scale(1.05);
        }

        .user-modal-footer {
            padding: 1rem 1.5rem;
            border-top: 1px solid #e9ecef;
            background-color: #f8f9fa;
            border-radius: 0 0 16px 16px;
            display: flex;
            justify-content: flex-end;
            gap: 0.5rem;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.05);
        }

        @media (max-width: 768px) {
            .user-modal-card {
                width: 98%;
                max-height: 95vh;
                margin: 1rem;
            }
            
            .user-modal-image {
                max-height: 50vh;
            }
            
            .user-modal-header,
            .user-modal-footer {
                padding: 1rem;
            }
            
            .user-modal-body {
                padding: 1.5rem;
            }
        }
    </style>
@endPushOnce
