@php
    $start = max(1, $paginator->currentPage() - 1);
    $end = min($paginator->lastPage(), $start + 2);
    $start = max(1, $end - 2);
@endphp

@if ($paginator->hasPages())
    <nav>
        <ul class="pagination justify-content-center">
            {{-- Previous Page Link --}}
            <li class="page-item {{ $paginator->onFirstPage() ? 'disabled' : '' }}">
                <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev" aria-label="Previous">
                    &lsaquo;
                </a>
            </li>

            {{-- Pagination Elements --}}
            @for ($page = $start; $page <= $end; $page++)
                <li class="page-item {{ $page == $paginator->currentPage() ? 'active' : '' }}">
                    <a class="page-link" href="{{ $paginator->url($page) }}">{{ $page }}</a>
                </li>
            @endfor

            {{-- Next Page Link --}}
            <li class="page-item {{ $paginator->hasMorePages() ? '' : 'disabled' }}">
                <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next" aria-label="Next">
                    &rsaquo;
                </a>
            </li>
        </ul>
    </nav>
@endif
