<!DOCTYPE html>
<html>
<head>
    <title>Location Test</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        select { margin: 10px 0; padding: 5px; width: 200px; }
        #debug { background: #f0f0f0; padding: 10px; margin: 10px 0; }
        pre { margin: 5px 0; }
    </style>
</head>
<body>
    <h1>Location Dropdown Test</h1>
    
    <form data-location-form>
        <label>Province:
            <select data-role="province" data-placeholder="Select Province">
                <option value="">Select Province</option>
                @foreach($provinces as $province)
                    <option value="{{ $province->id }}">{{ $province->name }}</option>
                @endforeach
            </select>
        </label>
        
        <label>District:
            <select data-role="district" 
                data-endpoint="{{ url('/api/provinces/:id/districts') }}"
                data-placeholder="Select District"
                data-disabled-placeholder="Select province first"
                disabled>
                <option value="">Select province first</option>
            </select>
        </label>
        
        <label>Commune:
            <select data-role="commune"
                data-endpoint="{{ url('/api/districts/:id/communes') }}"
                data-placeholder="Select Commune"
                data-disabled-placeholder="Select district first"
                disabled>
                <option value="">Select district first</option>
            </select>
        </label>
        
        <label>Village:
            <select data-role="village"
                data-endpoint="{{ url('/api/communes/:id/villages') }}"
                data-placeholder="Select Village"
                data-disabled-placeholder="Select commune first"
                disabled>
                <option value="">Select commune first</option>
            </select>
        </label>
    </form>
    
    <h3>Debug Output:</h3>
    <div id="debug"></div>
    
    <script>
        // Add debug logging
        const originalLog = console.log;
        console.log = function(...args) {
            originalLog.apply(console, args);
            const debugDiv = document.getElementById('debug');
            if (debugDiv) {
                debugDiv.innerHTML += '<pre>' + JSON.stringify(args) + '</pre>';
            }
        };
        
        // Simplified location script
        document.addEventListener('DOMContentLoaded', function() {
            console.log('DOM loaded');
            
            const form = document.querySelector('form[data-location-form]');
            console.log('Form found:', !!form);
            
            if (!form) return;
            
            const provinceSelect = form.querySelector('[data-role="province"]');
            const districtSelect = form.querySelector('[data-role="district"]');
            const communeSelect = form.querySelector('[data-role="commune"]');
            const villageSelect = form.querySelector('[data-role="village"]');
            
            console.log('Selects found:', {
                province: !!provinceSelect,
                district: !!districtSelect,
                commune: !!communeSelect,
                village: !!villageSelect
            });
            
            if (provinceSelect && districtSelect) {
                provinceSelect.addEventListener('change', function() {
                    const value = this.value;
                    console.log('Province changed to:', value);
                    
                    // Reset dependent selects
                    communeSelect.innerHTML = '<option value="">Select district first</option>';
                    communeSelect.disabled = true;
                    villageSelect.innerHTML = '<option value="">Select commune first</option>';
                    villageSelect.disabled = true;
                    
                    if (value) {
                        loadDistricts(value);
                    } else {
                        districtSelect.innerHTML = '<option value="">Select province first</option>';
                        districtSelect.disabled = true;
                    }
                });
            }
            
            async function loadDistricts(provinceId) {
                console.log('Loading districts for province:', provinceId);
                
                districtSelect.disabled = true;
                districtSelect.innerHTML = '<option value="">Loading...</option>';
                
                try {
                    const url = districtSelect.dataset.endpoint.replace(':id', provinceId);
                    console.log('Fetching URL:', url);
                    
                    const response = await fetch(url, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });
                    
                    console.log('Response status:', response.status);
                    
                    if (!response.ok) {
                        throw new Error('HTTP ' + response.status);
                    }
                    
                    const data = await response.json();
                    console.log('Data received:', data);
                    
                    const items = data.data || [];
                    districtSelect.innerHTML = '<option value="">Select District</option>';
                    
                    items.forEach(item => {
                        const option = document.createElement('option');
                        option.value = item.id;
                        option.textContent = item.name;
                        districtSelect.appendChild(option);
                    });
                    
                    districtSelect.disabled = false;
                    console.log('Districts loaded successfully');
                    
                } catch (error) {
                    console.error('Error loading districts:', error);
                    districtSelect.innerHTML = '<option value="">Error loading districts</option>';
                    districtSelect.disabled = true;
                }
            }
            
            if (districtSelect && communeSelect) {
                districtSelect.addEventListener('change', function() {
                    const value = this.value;
                    console.log('District changed to:', value);
                    
                    // Reset village select
                    villageSelect.innerHTML = '<option value="">Select commune first</option>';
                    villageSelect.disabled = true;
                    
                    if (value) {
                        loadCommunes(value);
                    } else {
                        communeSelect.innerHTML = '<option value="">Select district first</option>';
                        communeSelect.disabled = true;
                    }
                });
            }
            
            async function loadCommunes(districtId) {
                console.log('Loading communes for district:', districtId);
                
                communeSelect.disabled = true;
                communeSelect.innerHTML = '<option value="">Loading...</option>';
                
                try {
                    const url = communeSelect.dataset.endpoint.replace(':id', districtId);
                    console.log('Fetching URL:', url);
                    
                    const response = await fetch(url, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });
                    
                    console.log('Response status:', response.status);
                    
                    if (!response.ok) {
                        throw new Error('HTTP ' + response.status);
                    }
                    
                    const data = await response.json();
                    console.log('Data received:', data);
                    
                    const items = data.data || [];
                    communeSelect.innerHTML = '<option value="">Select Commune</option>';
                    
                    items.forEach(item => {
                        const option = document.createElement('option');
                        option.value = item.id;
                        option.textContent = item.name;
                        communeSelect.appendChild(option);
                    });
                    
                    communeSelect.disabled = false;
                    console.log('Communes loaded successfully');
                    
                } catch (error) {
                    console.error('Error loading communes:', error);
                    communeSelect.innerHTML = '<option value="">Error loading communes</option>';
                    communeSelect.disabled = true;
                }
            }
            
            if (communeSelect && villageSelect) {
                communeSelect.addEventListener('change', function() {
                    const value = this.value;
                    console.log('Commune changed to:', value);
                    
                    if (value) {
                        loadVillages(value);
                    } else {
                        villageSelect.innerHTML = '<option value="">Select commune first</option>';
                        villageSelect.disabled = true;
                    }
                });
            }
            
            async function loadVillages(communeId) {
                console.log('Loading villages for commune:', communeId);
                
                villageSelect.disabled = true;
                villageSelect.innerHTML = '<option value="">Loading...</option>';
                
                try {
                    const url = villageSelect.dataset.endpoint.replace(':id', communeId);
                    console.log('Fetching URL:', url);
                    
                    const response = await fetch(url, {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });
                    
                    console.log('Response status:', response.status);
                    
                    if (!response.ok) {
                        throw new Error('HTTP ' + response.status);
                    }
                    
                    const data = await response.json();
                    console.log('Data received:', data);
                    console.log('Number of villages:', (data.data || []).length);
                    
                    const items = data.data || [];
                    villageSelect.innerHTML = '<option value="">Select Village</option>';
                    
                    items.forEach(item => {
                        const option = document.createElement('option');
                        option.value = item.id;
                        option.textContent = item.name;
                        villageSelect.appendChild(option);
                    });
                    
                    villageSelect.disabled = false;
                    console.log('Villages loaded successfully');
                    
                } catch (error) {
                    console.error('Error loading villages:', error);
                    villageSelect.innerHTML = '<option value="">Error loading villages</option>';
                    villageSelect.disabled = true;
                }
            }
        });
    </script>
</body>
</html>
