<?php

use App\Models\User;
use App\Models\Province;
use Illuminate\View\View;

use App\Http\Controllers\Login;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\FatherController;
use App\Http\Controllers\CommuneController;
use App\Http\Controllers\VillageController;
use App\Http\Controllers\DistrictController;
use App\Http\Controllers\ProvinceController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EducationController;
use App\Http\Controllers\YearOfBirthController;
use App\Http\Controllers\EducationYearController;
use App\Http\Controllers\KudiController;
use App\Http\Controllers\MotherController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\MonktypeConroller;
use App\Http\Controllers\UserInfoController;

//-----------------Login Route ------------------
Route::get('/', function () {
    return redirect()->route('register.public');
});
Route::get('/login', function () {
    return view('admin.Auth.login');
})->name('login.form');
Route::post('/login', [Login::class, 'login'])->name('login');
Route::get('/logout', [Login::class, 'logout'])->name('logout');

//----------------- Public Registration (No Login Required) ------------
Route::match(['get','post'],'/register',[UserInfoController::class,'publicRegister'])->name('register.public');
Route::get('/profile/{id}', [UserInfoController::class, 'publicProfile'])->middleware('signed')->name('profile.public');
Route::match(['get','post'],'/profile/{id}/edit', [UserInfoController::class, 'publicEdit'])->middleware('signed')->name('profile.edit');
Route::get('/profile/{id}/download', [UserInfoController::class, 'downloadProfile'])->middleware('signed')->name('profile.download');

// Test route for location debugging
Route::get('/test-location', function() {
    return view('test_location', ['provinces' => \App\Models\Province::orderBy('name')->get()]);
});

// Debug route
Route::get('/debug-location', function() {
    return view('debug_location', ['provinces' => \App\Models\Province::orderBy('name')->get()]);
});

// Public API routes for location dropdowns (no auth required)
Route::prefix('api')->group(function () {
    Route::get('/provinces/{province}/districts', [LocationController::class, 'districts'])->name('api.districts');
    Route::get('/districts/{district}/communes', [LocationController::class, 'communes'])->name('api.communes');
    Route::get('/communes/{commune}/villages', [LocationController::class, 'villages'])->name('api.villages');
    Route::get('/education/{education}/years', [EducationYearController::class, 'byEducation'])->name('api.education.years');
});

Route::middleware(['auth.custom'])->group(function () {
    //--------------- Dashboard --------------------
    Route::get('/dashboard',[DashboardController::class,'index'])->name('dashboard.index');
    Route::get('/dashboard/export-members', [DashboardController::class, 'export'])->name('admin.export.members');

    //--------------- user Route --------------------
    Route::get('/user',[UserController::class,'index'])->name('user.index');
    Route::match(['get','post'],'/user/create',[UserController::class,'create'])->name('user.create');
    Route::match(['get','post'],'/user/edit/{id}',[UserController::class,'edit'])->name('user.edit');
    Route::get('/user/delete/{id}',[UserController::class,'delete'])->name('user.delete');
    Route::get('/user/{id}/detail',[UserController::class,'getUserDetail'])->name('user.detail');

    //--------------- userInfo Route --------------------
    Route::get('/userinfo',[UserInfoController::class,'index'])->name('userinfo.index');
    Route::match(['get','post'],'/userinfo/create',[UserInfoController::class,'create'])->name('userinfo.create');
    Route::match(['get','post'],'/userinfo/edit/{id}',[UserInfoController::class,'edit'])->name('userinfo.edit');
    Route::get('/userinfo/delete/{id}',[UserInfoController::class,'delete'])->name('userinfo.delete');
    Route::get('/userinfo/{id}/detail',[UserInfoController::class,'getUserDetail'])->name('userinfo.detail');

    //----------------- father ------------
    Route::get('/father',[FatherController::class,'index'])->name('father.index');
    Route::match(['get','post'],'/father/create',[FatherController::class,'create'])->name('father.create');
    Route::match(['get','post'],'/father/edit/{id}',[FatherController::class,'edit'])->name('father.edit');
    Route::get('/father/delete/{id}',[FatherController::class,'delete'])->name('father.delete');

    //----------------- Mother ------------
    Route::get('/mother',[MotherController::class,'index'])->name('mother.index');
    Route::match(['get','post'],'/mother/create',[MotherController::class,'create'])->name('mother.create');
    Route::match(['get','post'],'/mother/edit/{id}',[MotherController::class,'edit'])->name('mother.edit');
    Route::get('/mother/delete/{id}',[MotherController::class,'delete'])->name('mother.delete');

    Route::prefix('locations')->name('locations.')->group(function () {
        Route::get('/provinces/{province}/districts', [LocationController::class, 'districts'])->name('districts');
        Route::get('/districts/{district}/communes', [LocationController::class, 'communes'])->name('communes');
        Route::get('/communes/{commune}/villages', [LocationController::class, 'villages'])->name('villages');
    });

    //----------------- Education Year ------------
    Route::get('/educationyear',[EducationYearController::class,'index'])->name('educationyear.index');
    Route::match(['get','post'],'/educationyear/create',[EducationYearController::class,'create'])->name('educationyear.create');
    Route::match(['get','post'],'/educationyear/edit/{id}',[EducationYearController::class,'edit'])->name('educationyear.edit');
    Route::get('/educationyear/delete/{id}',[EducationYearController::class,'delete'])->name('educationyear.delete');
    Route::get('/education/{education}/years', [EducationYearController::class, 'byEducation'])->name('education.years');

    //----------------- Kudi Nummer ------------
    Route::get('/kudi',[KudiController::class,'index'])->name('kudi.index');
    Route::match(['get','post'],'/kudi/create',[KudiController::class,'create'])->name('kudi.create');
    Route::match(['get','post'],'/kudi/edit/{id}',[KudiController::class,'edit'])->name('kudi.edit');
    Route::get('/kudi/delete/{id}',[KudiController::class,'delete'])->name('kudi.delete');

    //----------------- Monk Type ------------
    Route::get('/monktype',[MonktypeConroller::class,'index'])->name('monktype.index');
    Route::match(['get','post'],'/monktype/create',[MonktypeConroller::class,'create'])->name('monktype.create');
    Route::match(['get','post'],'/monktype/edit/{id}',[MonktypeConroller::class,'edit'])->name('monktype.edit');
    Route::get('/monktype/delete/{id}',[MonktypeConroller::class,'delete'])->name('monktype.delete');

    //----------------- Province ------------
    Route::get('/province',[ProvinceController::class,'index'])->name('province.index');
    Route::match(['get','post'],'/province/create',[ProvinceController::class,'create'])->name('province.create');
    Route::match(['get','post'],'/province/edit/{id}',[ProvinceController::class,'edit'])->name('province.edit');
    Route::get('/province/delete/{id}',[ProvinceController::class,'delete'])->name('province.delete');

    //----------------- District ------------
    Route::get('/district',[DistrictController::class,'index'])->name('district.index');
    Route::match(['get','post'],'/district/create',[DistrictController::class,'create'])->name('district.create');
    Route::match(['get','post'],'/district/edit/{id}',[DistrictController::class,'edit'])->name('district.edit');
    Route::get('/district/delete/{id}',[DistrictController::class,'delete'])->name('district.delete');

    //----------------- Commune ------------
    Route::get('/commune',[CommuneController::class,'index'])->name('commune.index');
    Route::match(['get','post'],'/commune/create',[CommuneController::class,'create'])->name('commune.create');
    Route::match(['get','post'],'/commune/edit/{id}',[CommuneController::class,'edit'])->name('commune.edit');
    Route::get('/commune/delete/{id}',[CommuneController::class,'delete'])->name('commune.delete');

    //----------------- Village ------------
    Route::get('/village',[VillageController::class,'index'])->name('village.index');
    Route::match(['get','post'],'/village/create',[VillageController::class,'create'])->name('village.create');
    Route::match(['get','post'],'/village/edit/{id}',[VillageController::class,'edit'])->name('village.edit');
    Route::get('/village/delete/{id}',[VillageController::class,'delete'])->name('village.delete');

    //----------------- Education ------------
    Route::get('/education',[EducationController::class,'index'])->name('education.index');
    Route::match(['get','post'],'/education/create',[EducationController::class,'create'])->name('education.create');
    Route::match(['get','post'],'/education/edit/{id}',[EducationController::class,'edit'])->name('education.edit');
    Route::get('/education/delete/{id}',[EducationController::class,'delete'])->name('education.delete');
});

// API Routes for Location Data (AJAX)
Route::get('/api/provinces/{province_id}/districts', function($province_id) {
    $districts = \App\Models\District::where('province_id', $province_id)
        ->orderBy('name')
        ->get(['id', 'name']);
    
    return response()->json([
        'data' => $districts
    ]);
});

Route::get('/api/districts/{district_id}/communes', function($district_id) {
    $communes = \App\Models\Commune::where('district_id', $district_id)
        ->orderBy('name')
        ->get(['id', 'name']);
    
    return response()->json([
        'data' => $communes
    ]);
});

Route::get('/api/communes/{commune_id}/villages', function($commune_id) {
    $villages = \App\Models\Village::where('commune_id', $commune_id)
        ->orderBy('name')
        ->get(['id', 'name']);
    
    return response()->json([
        'data' => $villages
    ]);
});

Route::get('/api/education/{education_id}/years', function($education_id) {
    $years = \App\Models\EducationYear::where('education_id', $education_id)
        ->orderBy('name')
        ->get(['id', 'name']);
    
    return response()->json([
        'data' => $years
    ]);
});

Route::get('/api/users/filter', function(\Illuminate\Http\Request $request) {
    $query = \App\Models\UserModel::with(['kudi']);
    
    if ($request->has('kudi_id') && $request->kudi_id) {
        $query->where('kudi_id', $request->kudi_id);
    }
    
    $users = $query->orderBy('id')->get();
    
    $data = $users->map(function($user, $index) {
        return [
            'id' => $user->id,
            'name' => $user->name,
            'image' => $user->image,
            'kudi' => $user->kudi ? [
                'id' => $user->kudi->id,
                'kudi_number' => $user->kudi->kudi_number
            ] : null,
            'role' => $user->role,
            'action_buttons' => view('admin.user.action', ['user' => $user])->render()
        ];
    });
    
    return response()->json([
        'data' => $data
    ]);
});



