<?php
    $name = $name ?? 'date';
    $value = $value ?? null;
    $required = $required ?? false;
    $disabled = $disabled ?? false;
    $class = $class ?? 'form-control';
    
    // Extract current values
    if ($value) {
        try {
            $date = new DateTime($value);
            $currentDay = $date->format('d');
            $currentMonth = $date->format('m');
            $currentYear = $date->format('Y');
        } catch (Exception $e) {
            $currentDay = '';
            $currentMonth = '';
            $currentYear = '';
        }
    } else {
        $currentDay = '';
        $currentMonth = '';
        $currentYear = '';
    }
?>

<!-- Khmer Date Picker with Separate Dropdowns -->
<div class="khmer-date-separate-container">
    <div class="khmer-date-group">
        <select name="<?php echo e($name); ?>_day" class="khmer-date-select" <?php echo e($required ? 'required' : ''); ?> <?php echo e($disabled ? 'disabled' : ''); ?>>
            <option value="">ថ្ងៃ</option>
            <?php for($i = 1; $i <= 31; $i++): ?>
                <option value="<?php echo e(str_pad($i, 2, '0', STR_PAD_LEFT)); ?>" <?php echo e($currentDay == str_pad($i, 2, '0', STR_PAD_LEFT) ? 'selected' : ''); ?>><?php echo e($i); ?></option>
            <?php endfor; ?>
        </select>
    </div>
    
    <div class="khmer-date-group">
        <select name="<?php echo e($name); ?>_month" class="khmer-date-select" <?php echo e($required ? 'required' : ''); ?> <?php echo e($disabled ? 'disabled' : ''); ?>>
            <option value="">ខែ</option>
            <option value="01" <?php echo e($currentMonth == '01' ? 'selected' : ''); ?>>មករា</option>
            <option value="02" <?php echo e($currentMonth == '02' ? 'selected' : ''); ?>>កុម្ភៈ</option>
            <option value="03" <?php echo e($currentMonth == '03' ? 'selected' : ''); ?>>មីនា</option>
            <option value="04" <?php echo e($currentMonth == '04' ? 'selected' : ''); ?>>មេសា</option>
            <option value="05" <?php echo e($currentMonth == '05' ? 'selected' : ''); ?>>ឧសភា</option>
            <option value="06" <?php echo e($currentMonth == '06' ? 'selected' : ''); ?>>មិថុនា</option>
            <option value="07" <?php echo e($currentMonth == '07' ? 'selected' : ''); ?>>កក្កដា</option>
            <option value="08" <?php echo e($currentMonth == '08' ? 'selected' : ''); ?>>សីហា</option>
            <option value="09" <?php echo e($currentMonth == '09' ? 'selected' : ''); ?>>កញ្ញា</option>
            <option value="10" <?php echo e($currentMonth == '10' ? 'selected' : ''); ?>>តុលា</option>
            <option value="11" <?php echo e($currentMonth == '11' ? 'selected' : ''); ?>>វិច្ឆិកា</option>
            <option value="12" <?php echo e($currentMonth == '12' ? 'selected' : ''); ?>>ធ្នូ</option>
        </select>
    </div>
    
    <div class="khmer-date-group">
        <select name="<?php echo e($name); ?>_year" class="khmer-date-select" <?php echo e($required ? 'required' : ''); ?> <?php echo e($disabled ? 'disabled' : ''); ?>>
            <option value="">ឆ្នាំ</option>
            <?php
            $currentYear = date('Y');
            for ($i = $currentYear; $i >= $currentYear - 100; $i--) {
                $selected = ($currentYear == $i) ? 'selected' : '';
                echo "<option value=\"{$i}\" {$selected}>{$i}</option>";
            }
            ?>
        </select>
    </div>
    
    <!-- Hidden field to store the combined date -->
    <input type="hidden" name="<?php echo e($name); ?>" value="<?php echo e($value); ?>" class="khmer-date-hidden">
</div>

<style>
.khmer-date-separate-container {
    display: flex;
  
    gap: 8px;
    align-items: flex-start;
    
}

.khmer-date-group {
    display: flex;
    flex-direction: column;
    gap: 5px;
    min-width: 100px;
}

.khmer-date-label {
    font-size: 14px;
    font-weight: 500;
    color: #495057;
    font-family: 'Kantumruy Pro', system-ui, sans-serif;
    min-width: 60px;
    text-align: right;
}

.khmer-date-select {
    padding: 8px 12px;
    border: 2px solid #e9ecef;
    border-radius: 8px;
    font-size: 14px;
    background: white;
    cursor: pointer;
    font-family: 'Kantumruy Pro', system-ui, sans-serif;
    transition: all 0.2s ease;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    background-image: url("data:image/svg+xml;charset=UTF-8,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='none' stroke='currentColor' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3e%3cpolyline points='6 9 12 15 18 9'%3e%3c/polyline%3e%3c/svg%3e");
    background-repeat: no-repeat;
    background-position: right 8px center;
    background-size: 12px;
    padding-right: 30px;
}

.khmer-date-select:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.khmer-date-select:hover {
    border-color: #667eea;
}

@media (max-width: 768px) {
    .khmer-date-separate-container {
        flex-direction: column;
        align-items: stretch;
    }
    
    .khmer-date-group {
        min-width: auto;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const daySelect = document.querySelector('select[name="<?php echo e($name); ?>_day"]');
    const monthSelect = document.querySelector('select[name="<?php echo e($name); ?>_month"]');
    const yearSelect = document.querySelector('select[name="<?php echo e($name); ?>_year"]');
    const hiddenInput = document.querySelector('.khmer-date-hidden');
    
    if (daySelect && monthSelect && yearSelect && hiddenInput) {
        function updateHiddenDate() {
            const day = daySelect.value;
            const month = monthSelect.value;
            const year = yearSelect.value;
            
            if (day && month && year) {
                const dateString = year + '-' + month + '-' + day;
                hiddenInput.value = dateString;
                
                // Trigger change event
                const event = new Event('change', { bubbles: true });
                hiddenInput.dispatchEvent(event);
            }
        }
        
        daySelect.addEventListener('change', updateHiddenDate);
        monthSelect.addEventListener('change', updateHiddenDate);
        yearSelect.addEventListener('change', updateHiddenDate);
        
        // Update days when month or year changes (for leap years)
        function updateDays() {
            const year = parseInt(yearSelect.value);
            const month = parseInt(monthSelect.value);
            const daysInMonth = month && year ? new Date(year, month, 0).getDate() : 31;
            
            const currentDay = daySelect.value;
            const currentValue = daySelect.value;
            
            daySelect.innerHTML = '<option value="">-- ថ្ងៃ --</option>';
            for (let i = 1; i <= daysInMonth; i++) {
                const option = document.createElement('option');
                option.value = String(i).padStart(2, '0');
                option.textContent = i;
                if (i === parseInt(currentDay)) {
                    option.selected = true;
                }
                daySelect.appendChild(option);
            }
        }
        
        monthSelect.addEventListener('change', updateDays);
        yearSelect.addEventListener('change', updateDays);
    }
});
</script>
<?php /**PATH D:\monkManagment\resources\views/admin/components/khmer-date-picker-separate.blade.php ENDPATH**/ ?>