<!-- User Detail Modal -->
<div id="userDetailModal" class="custom-modal">
    <div class="custom-modal-content">
        <!-- Modal Header -->
        <div class="custom-modal-header mt-3">
            <h5 class="custom-modal-title">
                <i class="fas fa-user-circle me-2"></i>
                ព័ត៌មានលម្អិតសមាជិក
            </h5>
            <button type="button" class="custom-modal-close" onclick="closeUserDetailModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <!-- Modal Body -->
        <div class="custom-modal-body" id="userDetailContent">
            <!-- Content will be loaded dynamically -->
        </div>
        
        <!-- Modal Footer -->
        <div class="custom-modal-footer">
            <button type="button" class="btn btn-secondary" onclick="closeUserDetailModal()">
                <i class="fas fa-times me-2"></i>បិទ
            </button>
        </div>
    </div>
</div>

<style>
/* Enhanced Modal Styles */
.custom-modal {
    display: none;
    position: fixed;
    z-index: 10000;
    left: 50px;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.6);
    backdrop-filter: blur(5px);
    animation: fadeIn 0.3s ease;
    align-items: center;
    justify-content: center;
}

.custom-modal.show {
    display: flex !important;
}

.custom-modal-content {
    position: relative;
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    margin: 90px 0 60px 0;
    padding: 0;
    border: 1px solid rgba(0, 0, 0, 0.1);
    border-radius: 16px;
    width: 95%;
    max-width: 900px;
    max-height: 90vh;
    overflow: hidden;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    animation: slideUp 0.4s ease;
    display: flex;
    flex-direction: column;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes slideUp {
    from {
        opacity: 0;
        transform: translateY(50px) scale(0.95);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

.custom-modal-header {
    padding: 1rem 1.5rem;
    border-bottom: 1px solid #e9ecef;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 16px 16px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
    box-shadow: 0 2px 10px rgba(102, 126, 234, 0.2);
}

.custom-modal-title {
    margin: 0;
    font-size: 1.25rem;
    font-weight: 600;
    display: flex;
    align-items: center;
}

.custom-modal-close {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.25rem;
    font-weight: bold;
    cursor: pointer;
    background: rgba(255, 255, 255, 0.1);
    border: none;
    padding: 0.25rem;
    border-radius: 50%;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.custom-modal-close:hover {
    color: white;
    background: rgba(255, 255, 255, 0.2);
    transform: rotate(90deg);
}

.custom-modal-body {
    padding: 0;
    overflow-y: auto;
    flex: 1;
    background: #ffffff;
}

.custom-modal-footer {
    padding: 1rem 1.5rem;
    border-top: 1px solid #e9ecef;
    background-color: #f8f9fa;
    border-radius: 0 0 16px 16px;
    display: flex;
    justify-content: flex-end;
    gap: 0.5rem;
    box-shadow: 0 -1px 5px rgba(0, 0, 0, 0.03);
}

/* User Detail Content Styles */
.user-detail-container {
    padding: 2rem;
}

.user-profile-header {
    display: flex;
    align-items: center;
    gap: 2rem;
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: linear-gradient(135deg, #f3f4f6 0%, #e5e7eb 100%);
    border-radius: 16px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    border: 1px solid rgba(102, 126, 234, 0.1);
}

.user-profile-image {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    object-fit: cover;
    border: 4px solid #667eea;
    box-shadow: 0 4px 20px rgba(102, 126, 234, 0.3);
    transition: transform 0.3s ease;
}

.user-profile-image:hover {
    transform: scale(1.05);
}

.user-profile-info h3 {
    margin: 0 0 0.5rem 0;
    color: #212529;
    font-size: 1.5rem;
    font-weight: 600;
}

.user-profile-info .user-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    margin-top: 0.5rem;
}

.user-meta-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.25rem 0.75rem;
    background: white;
    border-radius: 20px;
    font-size: 0.875rem;
    color: #6c757d;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
}

.user-meta-item i {
    color: #667eea;
}

.info-section {
    margin-bottom: 2rem;
}

.info-section-title {
    font-size: 1.1rem;
    font-weight: 600;
    color: #495057;
    margin-bottom: 1rem;
    padding: 0.75rem 1rem;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 8px;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1rem;
}

.info-item {
    display: flex;
    padding: 1.25rem;
    background: linear-gradient(135deg, #ffffff 0%, #f9fafb 100%);
    border-radius: 12px;
    border-left: 4px solid #667eea;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
    border: 1px solid rgba(0, 0, 0, 0.05);
}

.info-item:hover {
    background: linear-gradient(135deg, #f8f9fa 0%, #f1f3f4 100%);
    transform: translateX(4px);
    box-shadow: 0 4px 16px rgba(102, 126, 234, 0.15);
}

.info-label {
    font-weight: 600;
    color: #495057;
    min-width: 120px;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.info-label i {
    color: #667eea;
    width: 16px;
}

.info-value {
    color: #212529;
    flex: 1;
}

.address-card {
    background: linear-gradient(135deg, #ffffff 0%, #f9fafb 100%);
    border-radius: 16px;
    padding: 1.75rem;
    margin-bottom: 1rem;
    border: 1px solid rgba(102, 126, 234, 0.1);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.06);
    transition: all 0.3s ease;
}

.address-card h6 {
    color: #667eea;
    font-weight: 600;
    margin-bottom: 0.75rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.address-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 24px rgba(102, 126, 234, 0.12);
}

.address-text {
    color: #495057;
    line-height: 1.6;
}

.empty-state {
    text-align: center;
    padding: 3rem;
    color: #6c757d;
}

.empty-state i {
    font-size: 3rem;
    margin-bottom: 1rem;
    color: #dee2e6;
}

.loading-spinner {
    border: 3px solid #f3f3f3;
    border-top: 3px solid #667eea;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    animation: spin 1s linear infinite;
    margin: 0 auto;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Responsive Design */
@media (max-width: 768px) {
    .custom-modal-content {
        width: 98%;
        max-height: 95vh;
        margin: 1rem;
    }
    
    .user-profile-header {
        flex-direction: column;
        text-align: center;
    }
    
    .user-profile-info .user-meta {
        justify-content: center;
    }
    
    .info-grid {
        grid-template-columns: 1fr;
    }
    
    .custom-modal-header,
    .custom-modal-footer {
        padding: 1rem;
    }
    
    .user-detail-container {
        padding: 1rem;
    }
}

/* Print Styles */
@media print {
    .custom-modal-header,
    .custom-modal-footer {
        display: none;
    }
    
    .custom-modal-content {
        box-shadow: none;
        border: 1px solid #000;
    }
}
</style><?php /**PATH D:\monkManagment\resources\views/User/partials/detail-modal.blade.php ENDPATH**/ ?>