<?php
    $start = max(1, $paginator->currentPage() - 1);
    $end = min($paginator->lastPage(), $start + 2);
    $start = max(1, $end - 2);
?>

<?php if($paginator->hasPages()): ?>
    <nav>
        <ul class="pagination justify-content-center">
            
            <li class="page-item <?php echo e($paginator->onFirstPage() ? 'disabled' : ''); ?>">
                <a class="page-link" href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev" aria-label="Previous">
                    &lsaquo;
                </a>
            </li>

            
            <?php for($page = $start; $page <= $end; $page++): ?>
                <li class="page-item <?php echo e($page == $paginator->currentPage() ? 'active' : ''); ?>">
                    <a class="page-link" href="<?php echo e($paginator->url($page)); ?>"><?php echo e($page); ?></a>
                </li>
            <?php endfor; ?>

            
            <li class="page-item <?php echo e($paginator->hasMorePages() ? '' : 'disabled'); ?>">
                <a class="page-link" href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next" aria-label="Next">
                    &rsaquo;
                </a>
            </li>
        </ul>
    </nav>
<?php endif; ?>
<?php /**PATH D:\monkManagment\resources\views/components/pagination/three-links.blade.php ENDPATH**/ ?>