<script>
(function() {
    console.log('Location select script loaded');
    
    // Cache for API responses
    const cache = new Map();
    
    function initLocationSelects() {
        const form = document.querySelector('form[data-location-form]');
        if (!form) {
            console.log('No form with data-location-form found');
            return;
        }
        
        console.log('Form found, initializing selects');
        
        const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
        
        // Province -> District (Birth Address)
        const provinceSelect = form.querySelector('[data-role="province"]');
        const districtSelect = form.querySelector('[data-role="district"]');
        const communeSelect = form.querySelector('[data-role="commune"]');
        const villageSelect = form.querySelector('[data-role="village"]');
        
        // Province -> District (Current Address)
        const currentProvinceSelect = form.querySelector('[data-role="current-province"]');
        const currentDistrictSelect = form.querySelector('[data-role="current-district"]');
        const currentCommuneSelect = form.querySelector('[data-role="current-commune"]');
        const currentVillageSelect = form.querySelector('[data-role="current-village"]');
        
        // Education
        const educationSelect = form.querySelector('[data-role="education"]');
        const educationYearSelect = form.querySelector('[data-role="education-year"]');
        
        console.log('Selects found:', {
            province: !!provinceSelect,
            district: !!districtSelect,
            commune: !!communeSelect,
            village: !!villageSelect,
            currentProvince: !!currentProvinceSelect,
            currentDistrict: !!currentDistrictSelect,
            currentCommune: !!currentCommuneSelect,
            currentVillage: !!currentVillageSelect,
            education: !!educationSelect,
            educationYear: !!educationYearSelect
        });
        
        async function loadOptions(select, url) {
            if (!select || !url) return;
            
            // Check cache first
            if (cache.has(url)) {
                const data = cache.get(url);
                populateOptions(select, data);
                return;
            }
            
            select.disabled = true;
            select.innerHTML = '<option value="">កំពុងផ្ទុក...</option>';
            
            try {
                console.log('Fetching:', url);
                const startTime = performance.now();
                
                const response = await fetch(url, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest',
                        'X-CSRF-TOKEN': csrfToken || ''
                    },
                    credentials: 'same-origin'
                });
                
                console.log('Response status:', response.status);
                
                if (!response.ok) {
                    throw new Error('HTTP ' + response.status);
                }
                
                const data = await response.json();
                console.log('Data received:', data);
                
                // Cache the response
                cache.set(url, data);
                
                const endTime = performance.now();
                console.log('Load time:', (endTime - startTime).toFixed(2), 'ms');
                
                populateOptions(select, data);
            } catch (error) {
                console.error('Load error:', error);
                select.innerHTML = '<option value="">មិនអាចផ្ទុកបានទេ</option>';
                select.disabled = true;
            }
        }
        
        function populateOptions(select, data) {
            const items = data.data || [];
            select.innerHTML = '<option value="">' + (select.dataset.placeholder || 'ជ្រើសរើស') + '</option>';
            
            items.forEach(item => {
                const option = document.createElement('option');
                option.value = item.id;
                option.textContent = item.name;
                select.appendChild(option);
            });
            
            select.disabled = false;
        }
        
        function resetSelect(select, placeholder) {
            if (!select) return;
            select.innerHTML = '<option value="">' + (placeholder || 'សូមជ្រើសរើសមុន') + '</option>';
            select.disabled = true;
        }
        
        // Province change handler
        if (provinceSelect && districtSelect) {
            provinceSelect.addEventListener('change', function() {
                const value = this.value;
                console.log('Province changed:', value);
                
                resetSelect(communeSelect, communeSelect?.dataset.disabledPlaceholder);
                resetSelect(villageSelect, villageSelect?.dataset.disabledPlaceholder);
                
                if (value) {
                    const url = districtSelect.dataset.endpoint.replace(':id', value);
                    loadOptions(districtSelect, url);
                } else {
                    resetSelect(districtSelect, districtSelect.dataset.disabledPlaceholder);
                }
            });
        }
        
        // District change handler
        if (districtSelect && communeSelect) {
            districtSelect.addEventListener('change', function() {
                const value = this.value;
                console.log('District changed:', value);
                
                resetSelect(villageSelect, villageSelect?.dataset.disabledPlaceholder);
                
                if (value) {
                    const url = communeSelect.dataset.endpoint.replace(':id', value);
                    loadOptions(communeSelect, url);
                } else {
                    resetSelect(communeSelect, communeSelect.dataset.disabledPlaceholder);
                }
            });
        }
        
        // Commune change handler
        if (communeSelect && villageSelect) {
            communeSelect.addEventListener('change', function() {
                const value = this.value;
                console.log('Commune changed:', value);
                
                if (value) {
                    const url = villageSelect.dataset.endpoint.replace(':id', value);
                    loadOptions(villageSelect, url);
                } else {
                    resetSelect(villageSelect, villageSelect.dataset.disabledPlaceholder);
                }
            });
        }
        
        // Education change handler
        if (educationSelect && educationYearSelect) {
            educationSelect.addEventListener('change', function() {
                const value = this.value;
                console.log('Education changed:', value);
                
                if (value) {
                    const url = educationYearSelect.dataset.endpoint.replace(':id', value);
                    loadOptions(educationYearSelect, url);
                } else {
                    resetSelect(educationYearSelect, educationYearSelect.dataset.disabledPlaceholder);
                }
            });
        }
        
        // Current Province change handler
        if (currentProvinceSelect && currentDistrictSelect) {
            currentProvinceSelect.addEventListener('change', function() {
                const value = this.value;
                console.log('Current Province changed:', value);
                
                resetSelect(currentCommuneSelect, currentCommuneSelect?.dataset.disabledPlaceholder);
                resetSelect(currentVillageSelect, currentVillageSelect?.dataset.disabledPlaceholder);
                
                if (value) {
                    const url = currentDistrictSelect.dataset.endpoint.replace(':id', value);
                    loadOptions(currentDistrictSelect, url);
                } else {
                    resetSelect(currentDistrictSelect, currentDistrictSelect.dataset.disabledPlaceholder);
                }
            });
        }
        
        // Current District change handler
        if (currentDistrictSelect && currentCommuneSelect) {
            currentDistrictSelect.addEventListener('change', function() {
                const value = this.value;
                console.log('Current District changed:', value);
                
                resetSelect(currentVillageSelect, currentVillageSelect?.dataset.disabledPlaceholder);
                
                if (value) {
                    const url = currentCommuneSelect.dataset.endpoint.replace(':id', value);
                    loadOptions(currentCommuneSelect, url);
                } else {
                    resetSelect(currentCommuneSelect, currentCommuneSelect.dataset.disabledPlaceholder);
                }
            });
        }
        
        // Current Commune change handler
        if (currentCommuneSelect && currentVillageSelect) {
            currentCommuneSelect.addEventListener('change', function() {
                const value = this.value;
                console.log('Current Commune changed:', value);
                
                if (value) {
                    const url = currentVillageSelect.dataset.endpoint.replace(':id', value);
                    loadOptions(currentVillageSelect, url);
                } else {
                    resetSelect(currentVillageSelect, currentVillageSelect.dataset.disabledPlaceholder);
                }
            });
        }
    }
    
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initLocationSelects);
    } else {
        initLocationSelects();
    }
})();
</script>
<?php /**PATH D:\monkManagment\resources\views/admin/components/location-select-script.blade.php ENDPATH**/ ?>