<!DOCTYPE html>
<html lang="km" dir="ltr" data-bs-theme="light">
<head>
    <meta charset="utf-8" />
    <title>កែប្រែព័ត៌មាន | <?php echo e($userinfo->name_kh); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <link href="https://fonts.googleapis.com/css2?family=Kantumruy+Pro:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/style/form.css')); ?>">
    <style>
        :root { --primary: #4c5cff; --muted: #6b7280; }
        body { margin: 0; min-height: 100vh; font-family: 'Kantumruy Pro', system-ui, sans-serif; background: linear-gradient(135deg, #f0f4ff, #faf5ff); }
        .page { padding: 1rem; max-width: 900px; margin: 0 auto; }
        .student-card { background: rgba(255,255,255,0.95); border-radius: 20px; padding: 1.5rem; box-shadow: 0 20px 50px rgba(27,39,92,0.1); }
        .card-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem; margin-bottom: 1.5rem; }
        .fieldset { margin-bottom: 1.5rem; }
        .field-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; }
        .field { display: flex; flex-direction: column; }
        .field span { font-size: 0.85rem; color: var(--muted); margin-bottom: 0.35rem; }
        .field input, .field select { padding: 0.75rem 1rem; border: 1px solid rgba(0,0,0,0.1); border-radius: 12px; font-size: 1rem; }
        .radio-group { display: flex; flex-wrap: wrap; gap: 0.5rem; }
        .form-actions { display: flex; gap: 1rem; flex-wrap: wrap; }
        .form-actions button, .form-actions a { flex: 1; min-width: 150px; padding: 0.85rem 1.5rem; border-radius: 12px; font-size: 1rem; font-weight: 600; text-align: center; text-decoration: none; }
        .btn { border: none; border-radius: 12px; padding: 0.85rem 1.5rem; font-size: 1rem; font-weight: 600; cursor: pointer; transition: all 0.2s ease; }
        .btn-outline { background: transparent; border: 2px solid #6b7280; color: #6b7280; }
        .btn-outline:hover { background: #6b7280; color: white; }
        .btn-primary { background: #4c5cff; color: white; }
        .btn-primary:hover { background: #3644ff; transform: translateY(-1px); }
        .form-footer { display: flex; gap: 1rem; flex-wrap: wrap; margin-top: 1.5rem; }
        @media (max-width: 768px) {
            .student-card { padding: 1rem; border-radius: 16px; }
            .card-header { flex-direction: column; align-items: flex-start; }
            .field-grid { grid-template-columns: 1fr; }
        }
        @media (max-width: 480px) {
            .page { padding: 0.75rem; }
            .student-card { padding: 0.75rem; border-radius: 12px; }
            .field input, .field select { padding: 0.65rem 0.85rem; font-size: 0.9rem; }
            .form-actions { flex-direction: column; }
            .form-actions button, .form-actions a { width: 100%; }
        }
    </style>
</head>
<body>
    <div class="page">
        <div style="text-align:center;padding:2rem 1rem;">
            <h1 style="font-size:1.75rem;margin:0 0 0.5rem;">កែប្រែព័ត៌មានរបស់អ្នក</h1>
            <p style="color:#6b7280;margin:0;"><?php echo e($userinfo->name_kh); ?> - <?php echo e($userinfo->id_number); ?></p>
        </div>
        <section class="form-section" id="register">
            <?php
                $selectedProvince = old('province_id', $userinfo->province_id ?? null);
                $selectedDistrict = old('district_id', $userinfo->district_id ?? null);
                $selectedCommune = old('commune_id', $userinfo->commune_id ?? null);
                $selectedCurrentProvince = old('current_province_id', $userinfo->current_province_id ?? null);
                $selectedCurrentDistrict = old('current_district_id', $userinfo->current_district_id ?? null);
                $selectedCurrentCommune = old('current_commune_id', $userinfo->current_commune_id ?? null);
            ?>
            <?php if(session('success')): ?>
                <div style="background: rgba(34, 197, 94, 0.15); color: #166534; border: 1px solid rgba(34, 197, 94, 0.3); border-radius: 12px; padding: 1rem; margin-bottom: 1rem;">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div style="background: rgba(239, 68, 68, 0.15); color: #991b1b; border: 1px solid rgba(239, 68, 68, 0.3); border-radius: 12px; padding: 1rem; margin-bottom: 1rem;">
                    <ul style="margin: 0; padding-left: 1.5rem;">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li style="margin-bottom: 0.25rem;"><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form class="register-form" data-location-form action="<?php echo e(URL::signedRoute('profile.edit', ['id' => $userinfo->id])); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                    <article class="student-card">
                        <div class="card-header"><div><h3>កែប្រែព័ត៌មាន</h3></div><span class="status-pill">កែប្រែ</span></div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4></div>
                            <div class="field-grid">
                                <label class="field"><span>អត្តលេខ *</span><input type="text" name="id_number" value="<?php echo e(old('id_number', $userinfo->id_number)); ?>" required></label>
                                <label class="field"><span>ឈ្មោះ (ខ្មែរ) *</span><input type="text" name="name_kh" value="<?php echo e(old('name_kh', $userinfo->name_kh)); ?>" required></label>
                                <label class="field"><span>ឈ្មោះ (ឡាតាំង) *</span><input type="text" name="name_en" value="<?php echo e(old('name_en', $userinfo->name_en)); ?>" required></label>
                                <label class="field radio-field"><span>ភិក្ខុ/សាមណេរ</span>
                                    <div class="radio-group">
                                        <?php $__currentLoopData = $monkTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monkType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <label class="radio-pill"><input type="radio" name="monk_type_id" value="<?php echo e($monkType->id); ?>" <?php echo e(old('monk_type_id', $userinfo->monk_type_id) == $monkType->id ? 'checked' : ''); ?>><span><?php echo e($monkType->name); ?></span></label>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </label>
                                <label class="field"><span>ថ្ងៃខែឆ្នាំកំណើត</span><input type="date" name="dob" value="<?php echo e(old('dob', $userinfo->dob ? \Carbon\Carbon::parse($userinfo->dob)->format('Y-m-d') : '')); ?>"></label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ទីកន្លែងកំណើត</h4></div>
                            <div class="field-grid">
                                <label class="field"><span>ខេត្ត/ក្រុង</span>
                                    <select name="province_id" data-role="province" data-placeholder="ជ្រើសរើសខេត្ត">
                                        <option value="">ជ្រើសរើសខេត្ត</option>
                                        <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($province->id); ?>" <?php echo e($selectedProvince == $province->id ? 'selected' : ''); ?>><?php echo e($province->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                                <label class="field"><span>ស្រុក/ខណ្ឌ</span>
                                    <select name="district_id" data-role="district" data-endpoint="<?php echo e(url('/api/provinces/:id/districts')); ?>" data-placeholder="ជ្រើសរើសស្រុក" <?php echo e($selectedProvince ? '' : 'disabled'); ?>>
                                        <option value=""><?php echo e($selectedProvince ? 'ជ្រើសរើសស្រុក' : 'សូមជ្រើសខេត្តជាមុន'); ?></option>
                                        <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($district->id); ?>" <?php echo e($selectedDistrict == $district->id ? 'selected' : ''); ?>><?php echo e($district->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                                <label class="field"><span>ឃុំ/សង្កាត់</span>
                                    <select name="commune_id" data-role="commune" data-endpoint="<?php echo e(url('/api/districts/:id/communes')); ?>" data-placeholder="ជ្រើសរើសឃុំ" <?php echo e($selectedDistrict ? '' : 'disabled'); ?>>
                                        <option value=""><?php echo e($selectedDistrict ? 'ជ្រើសរើសឃុំ' : 'សូមជ្រើសស្រុកជាមុន'); ?></option>
                                        <?php $__currentLoopData = $communes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($commune->id); ?>" <?php echo e($selectedCommune == $commune->id ? 'selected' : ''); ?>><?php echo e($commune->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                                <label class="field"><span>ភូមិ</span>
                                    <select name="village_id" data-role="village" data-endpoint="<?php echo e(url('/api/communes/:id/villages')); ?>" data-placeholder="ជ្រើសរើសភូមិ" <?php echo e($selectedCommune ? '' : 'disabled'); ?>>
                                        <option value=""><?php echo e($selectedCommune ? 'ជ្រើសរើសភូមិ' : 'សូមជ្រើសឃុំជាមុន'); ?></option>
                                        <?php $__currentLoopData = $villages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $village): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($village->id); ?>" <?php echo e(old('village_id', $userinfo->village_id) == $village->id ? 'selected' : ''); ?>><?php echo e($village->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ព័ត៌មានការសិក្សា</h4></div>
                            <div class="field-grid">
                                <label class="field"><span>កម្រិតវប្បធម៌</span>
                                    <select name="education_id" data-role="education" data-placeholder="ជ្រើសរើសកម្រិតវប្បធម៌">
                                        <option value="">ជ្រើសរើស</option>
                                        <?php $__currentLoopData = $educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $edu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($edu->id); ?>" <?php echo e(old('education_id', $userinfo->education_id) == $edu->id ? 'selected' : ''); ?>><?php echo e($edu->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                                <label class="field"><span>ឆ្នាំសិក្សា</span>
                                    <select name="education_year_id" data-role="education-year" data-endpoint="<?php echo e(url('/api/education/:id/years')); ?>" data-placeholder="ជ្រើសរើសឆ្នាំសិក្សា" <?php echo e(old('education_id', $userinfo->education_id) ? '' : 'disabled'); ?>>
                                        <option value=""><?php echo e(old('education_id', $userinfo->education_id) ? 'ជ្រើសរើសឆ្នាំសិក្សា' : 'សូមជ្រើសកម្រិតវប្បធម៌មានមុន'); ?></option>
                                        <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($year->id); ?>" <?php echo e(old('education_year_id', $userinfo->education_year_id) == $year->id ? 'selected' : ''); ?>><?php echo e($year->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                                <label class="field"><span>កុដិ</span>
                                    <select name="kudi_id">
                                        <option value="">ជ្រើសរើសកុដិ</option>
                                        <?php $__currentLoopData = $kudis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kudi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($kudi->id); ?>" <?php echo e(old('kudi_id', $userinfo->kudi_id) == $kudi->id ? 'selected' : ''); ?>><?php echo e($kudi->kudi_number); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>អាសយដ្ឋានបច្ចុប្បន្ន</h4><p>ទីកន្លែងរស់នៅបច្ចុប្បន្ន និងវត្តដែលស្នាក់នៅ</p></div>
                            <div class="field-grid">
                                <label class="field"><span>ឈ្មោះវត្ត</span><input type="text" name="temple_name" value="<?php echo e(old('temple_name', $userinfo->temple_name)); ?>" placeholder="ឧ. វត្តនាគវ័ន"></label>
                                <label class="field"><span>ខេត្ត/ក្រុង (បច្ចុប្បន្ន)</span>
                                    <select name="current_province_id" data-role="current-province" data-placeholder="ជ្រើសរើសខេត្ត">
                                        <option value="">ជ្រើសរើសខេត្ត</option>
                                        <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($province->id); ?>" <?php echo e(old('current_province_id', $userinfo->current_province_id) == $province->id ? 'selected' : ''); ?>><?php echo e($province->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                                <label class="field"><span>ស្រុក/ខណ្ឌ (បច្ចុប្បន្ន)</span>
                                    <select name="current_district_id" data-role="current-district" data-endpoint="<?php echo e(url('/api/provinces/:id/districts')); ?>" data-placeholder="ជ្រើសរើសស្រុក" <?php echo e($selectedCurrentProvince ? '' : 'disabled'); ?>>
                                        <option value=""><?php echo e($selectedCurrentProvince ? 'ជ្រើសរើសស្រុក' : 'សូមជ្រើសខេត្តជាមុន'); ?></option>
                                        <?php $__currentLoopData = $currentDistricts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($district->id); ?>" <?php echo e($selectedCurrentDistrict == $district->id ? 'selected' : ''); ?>><?php echo e($district->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                                <label class="field"><span>ឃុំ/សង្កាត់ (បច្ចុប្បន្ន)</span>
                                    <select name="current_commune_id" data-role="current-commune" data-endpoint="<?php echo e(url('/api/districts/:id/communes')); ?>" data-placeholder="ជ្រើសរើសឃុំ" <?php echo e($selectedCurrentDistrict ? '' : 'disabled'); ?>>
                                        <option value=""><?php echo e($selectedCurrentDistrict ? 'ជ្រើសរើសឃុំ' : 'សូមជ្រើសស្រុកជាមុន'); ?></option>
                                        <?php $__currentLoopData = $currentCommunes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($commune->id); ?>" <?php echo e($selectedCurrentCommune == $commune->id ? 'selected' : ''); ?>><?php echo e($commune->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                                <label class="field"><span>ភូមិ (បច្ចុប្បន្ន)</span>
                                    <select name="current_village_id" data-role="current-village" data-endpoint="<?php echo e(url('/api/communes/:id/villages')); ?>" data-placeholder="ជ្រើសរើសភូមិ" <?php echo e($selectedCurrentCommune ? '' : 'disabled'); ?>>
                                        <option value=""><?php echo e($selectedCurrentCommune ? 'ជ្រើសរើសភូមិ' : 'សូមជ្រើសឃុំជាមុន'); ?></option>
                                        <?php $__currentLoopData = $currentVillages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $village): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($village->id); ?>" <?php echo e(old('current_village_id', $userinfo->current_village_id) == $village->id ? 'selected' : ''); ?>><?php echo e($village->name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ព័ត៌មានមាតាបិតា</h4></div>
                            <div class="field-grid">
                                <label class="field"><span>ឈ្មោះឪពុក</span><input type="text" name="father_name" value="<?php echo e(old('father_name', $userinfo->father_name)); ?>"></label>
                                <label class="field"><span>មុខរបរ ឪពុក</span><input type="text" name="father_job" value="<?php echo e(old('father_job', $userinfo->father_job)); ?>"></label>
                                <label class="field"><span>ឈ្មោះម្ដាយ</span><input type="text" name="mother_name" value="<?php echo e(old('mother_name', $userinfo->mother_name)); ?>"></label>
                                <label class="field"><span>មុខរបរ ម្ដាយ</span><input type="text" name="mother_job" value="<?php echo e(old('mother_job', $userinfo->mother_job)); ?>"></label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ទំនាក់ទំនង</h4></div>
                            <div class="field-grid">
                                <label class="field field-full"><span>លេខទូរស័ព្ទ</span><input type="tel" name="phone_number" value="<?php echo e(old('phone_number', $userinfo->phone_number)); ?>"></label>
                                <div class="field field-full file-field">
                                    <span>រូបថត</span>
                                    <?php if($userinfo->image): ?>
                                        <div style="margin-bottom: 0.75rem;">
                                            <img src="<?php echo e(asset('storage/' . $userinfo->image)); ?>" alt="<?php echo e($userinfo->name_kh); ?>" style="width: 100px; height: 100px; object-fit: cover; border-radius: 12px; border: 2px solid #e5e7eb;">
                                            <p style="margin-top: 5px; font-size: 0.8rem; color: #6b7280;">រូបថតបច្ចុប្បន្ន</p>
                                        </div>
                                    <?php endif; ?>
                                    <input type="file" name="image" id="image-input" accept="image/*">
                                    <div id="image-preview" style="margin-top: 10px; display: none;">
                                        <img id="preview-img" style="max-width: 200px; max-height: 200px; border-radius: 8px; border: 2px solid #e5e7eb;">
                                        <p style="margin-top: 5px; font-size: 0.9rem; color: #6b7280;">រូបភាពដែលបានជ្រើសរើស</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                    <div class="form-footer">
                        <a href="<?php echo e(URL::signedRoute('profile.public', ['id' => $userinfo->id])); ?>" class="btn btn-outline">បោះបង់</a>
                        <button class="btn btn-primary" type="submit">រក្សាទុកការកែប្រែ</button>
                    </div>
                </form>
        </section>
    </div>
    <?php echo $__env->make('admin.components.location-select-script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <script src="<?php echo e(asset('assets/js/form-validation.js')); ?>" defer></script>
    <script>
        // Image preview functionality for edit form
        document.addEventListener('DOMContentLoaded', function() {
            const imageInput = document.getElementById('image-input');
            const imagePreview = document.getElementById('image-preview');
            const previewImg = document.getElementById('preview-img');
            
            if (imageInput && imagePreview && previewImg) {
                // Show current image initially
                <?php if($userinfo->image): ?>
                    const currentImage = '<?php echo e(asset('storage/' . $userinfo->image)); ?>';
                    previewImg.src = currentImage;
                    imagePreview.style.display = 'block';
                <?php endif; ?>
                
                imageInput.addEventListener('change', function(e) {
                    const file = e.target.files[0];
                    
                    if (file && file.type.startsWith('image/')) {
                        const reader = new FileReader();
                        
                        reader.onload = function(e) {
                            previewImg.src = e.target.result;
                            imagePreview.style.display = 'block';
                        };
                        
                        reader.readAsDataURL(file);
                    } else {
                        // If no file selected, show current image again
                        <?php if($userinfo->image): ?>
                            const currentImage = '<?php echo e(asset('storage/' . $userinfo->image)); ?>';
                            previewImg.src = currentImage;
                            imagePreview.style.display = 'block';
                        <?php else: ?>
                            imagePreview.style.display = 'none';
                            previewImg.src = '';
                        <?php endif; ?>
                    }
                });
            }
        });
    </script>
</body>
</html>
<?php /**PATH D:\monkManagment\resources\views/User/public-edit.blade.php ENDPATH**/ ?>