<!DOCTYPE html>
<html>
<head>
    <title>Location Test</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>
<body>
    <h1>Location Dropdown Test</h1>
    
    <form data-location-form>
        <label>Province:
            <select data-role="province" data-placeholder="Select Province">
                <option value="">Select Province</option>
                @foreach($provinces as $province)
                    <option value="{{ $province->id }}">{{ $province->name }}</option>
                @endforeach
            </select>
        </label>
        
        <label>District:
            <select data-role="district" 
                data-endpoint="{{ url('/api/provinces/:id/districts') }}"
                data-placeholder="Select District"
                data-disabled-placeholder="Select province first"
                disabled>
                <option value="">Select province first</option>
            </select>
        </label>
        
        <label>Commune:
            <select data-role="commune"
                data-endpoint="{{ url('/api/districts/:id/communes') }}"
                data-placeholder="Select Commune"
                data-disabled-placeholder="Select district first"
                disabled>
                <option value="">Select district first</option>
            </select>
        </label>
        
        <label>Village:
            <select data-role="village"
                data-endpoint="{{ url('/api/communes/:id/villages') }}"
                data-placeholder="Select Village"
                data-disabled-placeholder="Select commune first"
                disabled>
                <option value="">Select commune first</option>
            </select>
        </label>
    </form>
    
    <div id="debug"></div>
    
    @include('admin.components.location-select-script')
    
    <script>
        // Add debug logging
        const originalLog = console.log;
        console.log = function(...args) {
            originalLog.apply(console, args);
            const debugDiv = document.getElementById('debug');
            if (debugDiv) {
                debugDiv.innerHTML += '<pre>' + args.join(' ') + '</pre>';
            }
        };
    </script>
</body>
</html>
