<?php

require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

$kernel->bootstrap();

echo "Testing user data...\n";

try {
    $userCount = \App\Models\UserModel::count();
    echo "Total users: " . $userCount . "\n";
    
    if ($userCount > 0) {
        $users = \App\Models\UserModel::with('kudi')->take(3)->get();
        foreach ($users as $user) {
            echo "ID: " . $user->id . ", Name: " . $user->name . ", Kudi: " . ($user->kudi ? $user->kudi->kudi_number : 'None') . "\n";
            echo "  Image: " . ($user->image ? $user->image : 'None') . "\n";
        }
    } else {
        echo "No users found in database.\n";
    }
    
    $kudiCount = \App\Models\KudiModel::count();
    echo "Total kudis: " . $kudiCount . "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
